/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionListener;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.SystemEventListenerHolder;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.view.ViewDeclarationLanguage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.myfaces.application.ActionListenerImpl;
import org.apache.myfaces.application.NavigationHandlerImpl;
import org.apache.myfaces.application.ResourceHandlerImpl;
import org.apache.myfaces.application.StateManagerImpl;
import org.apache.myfaces.application.ViewHandlerImpl;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.Property;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.el.PropertyResolverImpl;
import org.apache.myfaces.el.VariableResolverToApplicationELResolverAdapter;
import org.apache.myfaces.el.convert.MethodExpressionToMethodBinding;
import org.apache.myfaces.el.convert.ValueBindingToValueExpression;
import org.apache.myfaces.el.convert.ValueExpressionToValueBinding;
import org.apache.myfaces.el.unified.ELResolverBuilder;
import org.apache.myfaces.el.unified.ResolverBuilderForFaces;
import org.apache.myfaces.el.unified.resolver.FacesCompositeELResolver;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.ELText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
extends Application {
    private static final Logger log = Logger.getLogger(ApplicationImpl.class.getName());
    private static final VariableResolver VARIABLERESOLVER = new VariableResolverToApplicationELResolverAdapter();
    private static final PropertyResolver PROPERTYRESOLVER = new PropertyResolverImpl();
    public static final String PROJECT_STAGE_SYSTEM_PROPERTY_NAME = "faces.PROJECT_STAGE";
    @Deprecated
    public static final String MYFACES_PROJECT_STAGE_SYSTEM_PROPERTY_NAME = "org.apache.myfaces.PROJECT_STAGE";
    public static final String DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE_PARAM_NAME = "javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE";
    private static final String PROJECT_STAGE_PARAM_NAME = "javax.faces.PROJECT_STAGE";
    private static final String LAZY_LOAD_CONFIG_OBJECTS_PARAM_NAME = "org.apache.myfaces.LAZY_LOAD_CONFIG_OBJECTS";
    private static final boolean LAZY_LOAD_CONFIG_OBJECTS_DEFAULT_VALUE = true;
    private Boolean _lazyLoadConfigObjects = null;
    private static final String RESOURCE_DEPENDENCY_UNIQUE_ID_KEY = "oam.view.resourceDependencyUniqueId";
    private Collection<Locale> _supportedLocales = Collections.emptySet();
    private Locale _defaultLocale;
    private String _messageBundle;
    private ViewHandler _viewHandler;
    private NavigationHandler _navigationHandler;
    private ActionListener _actionListener;
    private String _defaultRenderKitId;
    private ResourceHandler _resourceHandler;
    private StateManager _stateManager;
    private ArrayList<ELContextListener> _elContextListeners;
    private final Map<String, Object> _converterIdToClassMap = new ConcurrentHashMap<String, Object>();
    private final Map<Class<?>, Object> _converterTargetClassToConverterClassMap = new ConcurrentHashMap();
    private final Map<String, Object> _componentClassMap = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> _validatorClassMap = new ConcurrentHashMap<String, Object>();
    private final Map<Class<? extends SystemEvent>, SystemListenerEntry> _systemEventListenerClassMap = new ConcurrentHashMap<Class<? extends SystemEvent>, SystemListenerEntry>();
    private final Map<String, String> _defaultValidatorsIds = new HashMap<String, String>();
    private volatile Map<String, String> _cachedDefaultValidatorsIds = null;
    private final Map<String, Object> _behaviorClassMap = new ConcurrentHashMap<String, Object>();
    private final RuntimeConfig _runtimeConfig;
    private ELResolver elResolver;
    private ELResolverBuilder resolverBuilderForFaces;
    private ProjectStage _projectStage;
    private volatile boolean _firstRequestProcessed = false;
    private final Map<Class<?>, List<ListenerFor>> _classToListenerForMap = new ConcurrentHashMap();
    private final Map<Class<?>, List<ResourceDependency>> _classToResourceDependencyMap = new ConcurrentHashMap();
    private List<Class<? extends Converter>> _noArgConstructorConverterClasses = new CopyOnWriteArrayList<Class<? extends Converter>>();
    private boolean _dateTimeConverterDefaultTimeZoneIsSystemTimeZone = false;
    private static final UIComponent NOTHING = new UIComponentBase(){

        public String getFamily() {
            return null;
        }
    };

    public ApplicationImpl() {
        this(ApplicationImpl.getRuntimeConfig());
    }

    private static RuntimeConfig getRuntimeConfig() {
        return RuntimeConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext());
    }

    ApplicationImpl(RuntimeConfig runtimeConfig) {
        String configParam;
        if (runtimeConfig == null) {
            throw new IllegalArgumentException("runtimeConfig must mot be null");
        }
        this._viewHandler = new ViewHandlerImpl();
        this._navigationHandler = new NavigationHandlerImpl();
        this._actionListener = new ActionListenerImpl();
        this._defaultRenderKitId = "HTML_BASIC";
        this._stateManager = new StateManagerImpl();
        this._elContextListeners = new ArrayList();
        this._resourceHandler = new ResourceHandlerImpl();
        this._runtimeConfig = runtimeConfig;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New Application instance created");
        }
        if ((configParam = this.getFaceContext().getExternalContext().getInitParameter(DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE_PARAM_NAME)) != null && configParam.toLowerCase().equals("true")) {
            this._dateTimeConverterDefaultTimeZoneIsSystemTimeZone = true;
        }
    }

    public final void addELResolver(ELResolver resolver) {
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("It is illegal to add a resolver after the first request is processed");
        }
        if (resolver != null) {
            this._runtimeConfig.addApplicationElResolver(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultValidatorId(String validatorId) {
        if (this._validatorClassMap.containsKey(validatorId)) {
            Class<?> validatorClass = this.getObjectFromClassMap(validatorId, this._validatorClassMap);
            String className = validatorClass instanceof Class ? validatorClass.getName() : ((Object)validatorClass).toString();
            Map<String, String> map = this._defaultValidatorsIds;
            synchronized (map) {
                this._defaultValidatorsIds.put(validatorId, className);
                this._cachedDefaultValidatorsIds = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultValidatorInfo() {
        Map<String, String> cachedMap = this._cachedDefaultValidatorsIds;
        if (cachedMap == null) {
            Map<String, String> map = this._defaultValidatorsIds;
            synchronized (map) {
                if (this._cachedDefaultValidatorsIds == null) {
                    this._cachedDefaultValidatorsIds = Collections.unmodifiableMap(this._defaultValidatorsIds);
                }
                cachedMap = this._cachedDefaultValidatorsIds;
            }
        }
        return cachedMap;
    }

    public final ELResolver getELResolver() {
        if (this.elResolver == null) {
            this.elResolver = this.createFacesResolver();
        }
        return this.elResolver;
    }

    private ELResolver createFacesResolver() {
        boolean supportJSPAndFacesEL = MyfacesConfig.getCurrentInstance(this.getFaceContext().getExternalContext()).isSupportJSPAndFacesEL();
        CompositeELResolver resolver = supportJSPAndFacesEL ? new FacesCompositeELResolver(FacesCompositeELResolver.Scope.Faces) : new CompositeELResolver();
        this.getResolverBuilderForFaces().build(resolver);
        return resolver;
    }

    protected final ELResolverBuilder getResolverBuilderForFaces() {
        if (this.resolverBuilderForFaces == null) {
            this.resolverBuilderForFaces = new ResolverBuilderForFaces(this._runtimeConfig);
        }
        return this.resolverBuilderForFaces;
    }

    public final void setResolverBuilderForFaces(ELResolverBuilder factory) {
        this.resolverBuilderForFaces = factory;
    }

    public final java.util.ResourceBundle getResourceBundle(FacesContext facesContext, String name) throws FacesException, NullPointerException {
        this.checkNull(facesContext, "facesContext");
        this.checkNull(name, "name");
        String bundleName = this.getBundleName(facesContext, name);
        if (bundleName == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null && viewRoot.getLocale() != null) {
            locale = viewRoot.getLocale();
        }
        try {
            return this.getResourceBundle(bundleName, locale, this.getClassLoader());
        }
        catch (MissingResourceException e) {
            try {
                return this.getResourceBundle(bundleName, locale, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MissingResourceException e1) {
                throw new FacesException("Could not load resource bundle for name '" + name + "': " + e.getMessage(), (Throwable)e1);
            }
        }
    }

    private ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    String getBundleName(FacesContext facesContext, String name) {
        ResourceBundle bundle = this.getRuntimeConfig(facesContext).getResourceBundle(name);
        return bundle != null ? bundle.getBaseName() : null;
    }

    java.util.ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader loader) throws MissingResourceException {
        return java.util.ResourceBundle.getBundle(name, locale, loader);
    }

    final RuntimeConfig getRuntimeConfig(FacesContext facesContext) {
        return RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
    }

    final FacesContext getFaceContext() {
        return FacesContext.getCurrentInstance();
    }

    public final UIComponent createComponent(ValueExpression componentExpression, FacesContext facesContext, String componentType) throws FacesException, NullPointerException {
        this.checkNull(componentExpression, "componentExpression");
        this.checkNull(facesContext, "facesContext");
        this.checkNull(componentType, "componentType");
        ELContext elContext = facesContext.getELContext();
        try {
            UIComponent createdComponent;
            Object retVal = componentExpression.getValue(elContext);
            if (retVal instanceof UIComponent) {
                createdComponent = (UIComponent)retVal;
                this._handleAnnotations(facesContext, createdComponent, createdComponent);
            } else {
                createdComponent = this.createComponent(facesContext, componentType);
                componentExpression.setValue(elContext, (Object)createdComponent);
            }
            return createdComponent;
        }
        catch (FacesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType, String rendererType) {
        UIComponent component = this.createComponent(componentExpression, context, componentType);
        if (rendererType != null) {
            this._inspectRenderer(context, component, componentType, rendererType);
        }
        return component;
    }

    public final ExpressionFactory getExpressionFactory() {
        return this._runtimeConfig.getExpressionFactory();
    }

    public final <T> T evaluateExpressionGet(FacesContext context, String expression, Class<? extends T> expectedType) throws ELException {
        ELContext elContext = context.getELContext();
        ExpressionFactory factory = this.getExpressionFactory();
        return (T)factory.createValueExpression(elContext, expression, expectedType).getValue(elContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addELContextListener(ELContextListener listener) {
        ArrayList<ELContextListener> arrayList = this._elContextListeners;
        synchronized (arrayList) {
            this._elContextListeners.add(listener);
        }
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source) {
        this.checkNull(systemEventClass, "systemEventClass");
        this.checkNull(source, "source");
        if (!facesContext.isProcessingEvents()) {
            return;
        }
        if (sourceBaseType == null) {
            sourceBaseType = source.getClass();
        }
        try {
            SystemListenerEntry systemListenerEntry;
            UIViewRoot uiViewRoot;
            SystemEvent event = null;
            if (source instanceof SystemEventListenerHolder) {
                SystemEventListenerHolder holder = (SystemEventListenerHolder)source;
                event = ApplicationImpl._traverseListenerList(holder.getListenersForEventClass(systemEventClass), systemEventClass, source, event);
            }
            if ((uiViewRoot = facesContext.getViewRoot()) != null) {
                event = ApplicationImpl._traverseListenerListWithCopy(uiViewRoot.getViewListenersForEventClass(systemEventClass), systemEventClass, source, event);
            }
            if ((systemListenerEntry = this._systemEventListenerClassMap.get(systemEventClass)) != null) {
                systemListenerEntry.publish(systemEventClass, sourceBaseType, source, event);
            }
        }
        catch (AbortProcessingException e) {
            log.log(Level.SEVERE, "Event processing was aborted", e);
        }
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        this.publishEvent(facesContext, systemEventClass, source.getClass(), source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeELContextListener(ELContextListener listener) {
        ArrayList<ELContextListener> arrayList = this._elContextListeners;
        synchronized (arrayList) {
            this._elContextListeners.remove(listener);
        }
    }

    public final ELContextListener[] getELContextListeners() {
        return this._elContextListeners.toArray(new ELContextListener[this._elContextListeners.size()]);
    }

    public final void setActionListener(ActionListener actionListener) {
        this.checkNull(actionListener, "actionListener");
        this._actionListener = actionListener;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set actionListener = " + actionListener.getClass().getName());
        }
    }

    public final ActionListener getActionListener() {
        return this._actionListener;
    }

    public Iterator<String> getBehaviorIds() {
        return this._behaviorClassMap.keySet().iterator();
    }

    public final Iterator<String> getComponentTypes() {
        return this._componentClassMap.keySet().iterator();
    }

    public final Iterator<String> getConverterIds() {
        return this._converterIdToClassMap.keySet().iterator();
    }

    public final Iterator<Class<?>> getConverterTypes() {
        return this._converterTargetClassToConverterClassMap.keySet().iterator();
    }

    public final void setDefaultLocale(Locale locale) {
        this.checkNull(locale, "locale");
        this._defaultLocale = locale;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set defaultLocale = " + locale.getCountry() + " " + locale.getLanguage());
        }
    }

    public final Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public final void setMessageBundle(String messageBundle) {
        this.checkNull(messageBundle, "messageBundle");
        this._messageBundle = messageBundle;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set MessageBundle = " + messageBundle);
        }
    }

    public final String getMessageBundle() {
        return this._messageBundle;
    }

    public final void setNavigationHandler(NavigationHandler navigationHandler) {
        this.checkNull(navigationHandler, "navigationHandler");
        this._navigationHandler = navigationHandler;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set NavigationHandler = " + navigationHandler.getClass().getName());
        }
    }

    public final NavigationHandler getNavigationHandler() {
        return this._navigationHandler;
    }

    @Deprecated
    public final void setPropertyResolver(PropertyResolver propertyResolver) {
        this.checkNull(propertyResolver, "propertyResolver");
        if (this.getFaceContext() != null) {
            throw new IllegalStateException("propertyResolver must be defined before request processing");
        }
        this._runtimeConfig.setPropertyResolver(propertyResolver);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set PropertyResolver = " + propertyResolver.getClass().getName());
        }
    }

    public ProjectStage getProjectStage() {
        if (this._projectStage == null) {
            String stageName = null;
            stageName = System.getProperty(PROJECT_STAGE_SYSTEM_PROPERTY_NAME);
            if (stageName == null && (stageName = System.getProperty(MYFACES_PROJECT_STAGE_SYSTEM_PROPERTY_NAME)) != null) {
                log.log(Level.WARNING, "The system property org.apache.myfaces.PROJECT_STAGE has been replaced by faces.PROJECT_STAGE! Please change your settings.");
            }
            if (stageName == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    Object temp = ctx.lookup("java:comp/env/jsf/ProjectStage");
                    if (temp != null) {
                        if (temp instanceof String) {
                            stageName = (String)temp;
                        } else {
                            log.severe("JNDI lookup for key java:comp/env/jsf/ProjectStage should return a java.lang.String value");
                        }
                    }
                }
                catch (NamingException e) {
                }
                catch (NoClassDefFoundError er) {
                    // empty catch block
                }
            }
            if (stageName == null) {
                FacesContext context = FacesContext.getCurrentInstance();
                stageName = context.getExternalContext().getInitParameter(PROJECT_STAGE_PARAM_NAME);
            }
            if (stageName != null) {
                try {
                    this._projectStage = ProjectStage.valueOf((String)stageName);
                    return this._projectStage;
                }
                catch (IllegalArgumentException e) {
                    log.log(Level.SEVERE, "Couldn't discover the current project stage", e);
                }
            } else if (log.isLoggable(Level.INFO)) {
                log.info("Couldn't discover the current project stage, using " + ProjectStage.Production);
            }
            this._projectStage = ProjectStage.Production;
        }
        return this._projectStage;
    }

    @Deprecated
    public final PropertyResolver getPropertyResolver() {
        return PROPERTYRESOLVER;
    }

    public final void setResourceHandler(ResourceHandler resourceHandler) {
        this.checkNull(resourceHandler, "resourceHandler");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setResourceHandler may not be executed after a lifecycle request has been completed");
        }
        this._resourceHandler = resourceHandler;
    }

    public final ResourceHandler getResourceHandler() {
        return this._resourceHandler;
    }

    public final void setSupportedLocales(Collection<Locale> locales) {
        this.checkNull(locales, "locales");
        this._supportedLocales = locales;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set SupportedLocales");
        }
    }

    public final Iterator<Locale> getSupportedLocales() {
        return this._supportedLocales.iterator();
    }

    public final Iterator<String> getValidatorIds() {
        return this._validatorClassMap.keySet().iterator();
    }

    @Deprecated
    public final void setVariableResolver(VariableResolver variableResolver) {
        this.checkNull(variableResolver, "variableResolver");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("variableResolver must be defined before request processing");
        }
        this._runtimeConfig.setVariableResolver(variableResolver);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set VariableResolver = " + variableResolver.getClass().getName());
        }
    }

    @Deprecated
    public final VariableResolver getVariableResolver() {
        return VARIABLERESOLVER;
    }

    public final void setViewHandler(ViewHandler viewHandler) {
        this.checkNull(viewHandler, "viewHandler");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setViewHandler may not be executed after a lifecycle request has been completed");
        }
        this._viewHandler = viewHandler;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set ViewHandler = " + viewHandler.getClass().getName());
        }
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.subscribeToEvent(systemEventClass, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        SystemListenerEntry systemListenerEntry;
        this.checkNull(systemEventClass, "systemEventClass");
        this.checkNull(listener, "listener");
        Map<Class<? extends SystemEvent>, SystemListenerEntry> map = this._systemEventListenerClassMap;
        synchronized (map) {
            systemListenerEntry = this._systemEventListenerClassMap.get(systemEventClass);
            if (systemListenerEntry == null) {
                systemListenerEntry = new SystemListenerEntry();
                this._systemEventListenerClassMap.put(systemEventClass, systemListenerEntry);
            }
        }
        systemListenerEntry.addListener(listener, sourceClass);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.unsubscribeFromEvent(systemEventClass, null, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        this.checkNull(systemEventClass, "systemEventClass");
        this.checkNull(listener, "listener");
        SystemListenerEntry systemListenerEntry = this._systemEventListenerClassMap.get(systemEventClass);
        if (systemListenerEntry != null) {
            systemListenerEntry.removeListener(listener, sourceClass);
        }
    }

    public final ViewHandler getViewHandler() {
        return this._viewHandler;
    }

    public void addBehavior(String behaviorId, String behaviorClass) {
        this.checkNull(behaviorId, "behaviorId");
        this.checkEmpty(behaviorId, "behaviorId");
        this.checkNull(behaviorClass, "behaviorClass");
        this.checkEmpty(behaviorClass, "behaviorClass");
        try {
            if (this.isLazyLoadConfigObjects()) {
                this._behaviorClassMap.put(behaviorId, behaviorClass);
            } else {
                this._behaviorClassMap.put(behaviorId, ClassUtils.simpleClassForName(behaviorClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Behavior class = " + behaviorClass + " for id = " + behaviorId);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Behavior class " + behaviorClass + " not found", e);
        }
    }

    public final void addComponent(String componentType, String componentClassName) {
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        this.checkNull(componentClassName, "componentClassName");
        this.checkEmpty(componentClassName, "componentClassName");
        try {
            if (this.isLazyLoadConfigObjects()) {
                this._componentClassMap.put(componentType, componentClassName);
            } else {
                this._componentClassMap.put(componentType, ClassUtils.simpleClassForName(componentClassName));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Component class = " + componentClassName + " for type = " + componentType);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Component class " + componentClassName + " not found", e);
        }
    }

    public final void addConverter(String converterId, String converterClass) {
        this.checkNull(converterId, "converterId");
        this.checkEmpty(converterId, "converterId");
        this.checkNull(converterClass, "converterClass");
        this.checkEmpty(converterClass, "converterClass");
        try {
            if (this.isLazyLoadConfigObjects()) {
                this._converterIdToClassMap.put(converterId, converterClass);
            } else {
                this._converterIdToClassMap.put(converterId, ClassUtils.simpleClassForName(converterClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Converter id = " + converterId + " converterClass = " + converterClass);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Converter class " + converterClass + " not found", e);
        }
    }

    public final void addConverter(Class<?> targetClass, String converterClass) {
        this.checkNull(targetClass, "targetClass");
        this.checkNull(converterClass, "converterClass");
        this.checkEmpty(converterClass, "converterClass");
        try {
            if (this.isLazyLoadConfigObjects()) {
                this._converterTargetClassToConverterClassMap.put(targetClass, converterClass);
            } else {
                this._converterTargetClassToConverterClassMap.put(targetClass, ClassUtils.simpleClassForName(converterClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Converter for class = " + targetClass + " converterClass = " + converterClass);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Converter class " + converterClass + " not found", e);
        }
    }

    public final void addValidator(String validatorId, String validatorClass) {
        this.checkNull(validatorId, "validatorId");
        this.checkEmpty(validatorId, "validatorId");
        this.checkNull(validatorClass, "validatorClass");
        this.checkEmpty(validatorClass, "validatorClass");
        try {
            if (this.isLazyLoadConfigObjects()) {
                this._validatorClassMap.put(validatorId, validatorClass);
            } else {
                this._validatorClassMap.put(validatorId, ClassUtils.simpleClassForName(validatorClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Validator id = " + validatorId + " class = " + validatorClass);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Validator class " + validatorClass + " not found", e);
        }
    }

    public Behavior createBehavior(String behaviorId) throws FacesException {
        this.checkNull(behaviorId, "behaviorId");
        this.checkEmpty(behaviorId, "behaviorId");
        Class<?> behaviorClass = this.getObjectFromClassMap(behaviorId, this._behaviorClassMap);
        if (behaviorClass == null) {
            throw new FacesException("Could not find any registered behavior-class for behaviorId : " + behaviorId);
        }
        try {
            ClientBehaviorBase clientBehavior;
            String renderType;
            Behavior behavior = (Behavior)behaviorClass.newInstance();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this._handleAttachedResourceDependencyAnnotations(facesContext, behavior);
            if (behavior instanceof ClientBehaviorBase && (renderType = (clientBehavior = (ClientBehaviorBase)behavior).getRendererType()) != null) {
                ClientBehaviorRenderer cbr = facesContext.getRenderKit().getClientBehaviorRenderer(renderType);
                this._handleAttachedResourceDependencyAnnotations(facesContext, cbr);
            }
            return behavior;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate behavior " + behaviorClass, e);
            throw new FacesException("Could not instantiate behavior: " + behaviorClass, (Throwable)e);
        }
    }

    public UIComponent createComponent(FacesContext context, Resource componentResource) {
        this.checkNull(context, "context");
        this.checkNull(componentResource, "componentResource");
        UIComponent component = null;
        Class componentClass = null;
        UIViewRoot view = context.getViewRoot();
        Application application = context.getApplication();
        ViewDeclarationLanguage vdl = application.getViewHandler().getViewDeclarationLanguage(context, view.getViewId());
        BeanInfo metadata = vdl.getComponentMetadata(context, componentResource);
        if (metadata == null) {
            throw new FacesException("Could not get component metadata for " + componentResource.getResourceName() + ". Did you forget to specify <composite:interface>?");
        }
        BeanDescriptor descriptor = metadata.getBeanDescriptor();
        ValueExpression componentType = (ValueExpression)descriptor.getValue("javax.faces.component.COMPOSITE_COMPONENT_TYPE");
        boolean annotationsApplied = false;
        if (componentType != null) {
            component = application.createComponent((String)componentType.getValue(context.getELContext()));
            annotationsApplied = true;
        } else {
            Resource resource = vdl.getScriptComponentResource(context, componentResource);
            if (resource != null) {
                String name = resource.getResourceName();
                String className = name.substring(0, name.lastIndexOf(46));
                component = (UIComponent)ClassUtils.newInstance(className);
            } else {
                String fqcn;
                block17: {
                    boolean isProduction = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production);
                    String name = componentResource.getResourceName();
                    String className = name.substring(0, name.lastIndexOf(46));
                    fqcn = componentResource.getLibraryName() + "." + className;
                    if (isProduction) {
                        componentClass = (Class)this._componentClassMap.get(fqcn);
                    }
                    if (componentClass == null) {
                        try {
                            componentClass = ClassUtils.classForName(fqcn);
                            if (isProduction) {
                                this._componentClassMap.put(fqcn, componentClass);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (!isProduction) break block17;
                            this._componentClassMap.put(fqcn, NOTHING.getClass());
                        }
                    }
                }
                if (componentClass != null && NOTHING.getClass() != componentClass) {
                    try {
                        component = (UIComponent)componentClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        log.log(Level.SEVERE, "Could not instantiate component class name = " + fqcn, e);
                        throw new FacesException("Could not instantiate component class name = " + fqcn, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.log(Level.SEVERE, "Could not instantiate component class name = " + fqcn, e);
                        throw new FacesException("Could not instantiate component class name = " + fqcn, (Throwable)e);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Could not instantiate component class name = " + fqcn, e);
                    }
                }
                if (component == null) {
                    component = application.createComponent(context, "javax.faces.NamingContainer", null);
                    annotationsApplied = true;
                }
            }
        }
        component.setRendererType("javax.faces.Composite");
        component.getAttributes().put("javax.faces.application.Resource.ComponentResource", componentResource);
        component.getAttributes().put("javax.faces.component.BEANINFO_KEY", metadata);
        if (!annotationsApplied) {
            this._handleAnnotations(context, component, component);
        }
        return component;
    }

    public UIComponent createComponent(FacesContext context, String componentType, String rendererType) {
        this.checkNull(context, "context");
        this.checkNull(componentType, "componentType");
        UIComponent component = this.createComponent(context, componentType);
        if (rendererType != null) {
            this._inspectRenderer(context, component, componentType, rendererType);
        }
        return component;
    }

    private final UIComponent createComponent(FacesContext facesContext, String componentType) throws FacesException {
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        Class<?> componentClass = this.getObjectFromClassMap(componentType, this._componentClassMap);
        if (componentClass == null) {
            log.log(Level.SEVERE, "Undefined component type " + componentType);
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            UIComponent component = (UIComponent)componentClass.newInstance();
            this._handleAnnotations(facesContext, component, component);
            return component;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate component componentType = " + componentType, e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, (Throwable)e);
        }
    }

    public final UIComponent createComponent(String componentType) throws FacesException {
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        Class<?> componentClass = this.getObjectFromClassMap(componentType, this._componentClassMap);
        if (componentClass == null) {
            log.log(Level.SEVERE, "Undefined component type " + componentType);
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            UIComponent component = (UIComponent)componentClass.newInstance();
            this._handleAnnotations(FacesContext.getCurrentInstance(), component, component);
            return component;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate component componentType = " + componentType, e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, (Throwable)e);
        }
    }

    @Deprecated
    public final UIComponent createComponent(ValueBinding valueBinding, FacesContext facesContext, String componentType) throws FacesException {
        this.checkNull(valueBinding, "valueBinding");
        this.checkNull(facesContext, "facesContext");
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        ValueBindingToValueExpression valExpression = new ValueBindingToValueExpression(valueBinding);
        return this.createComponent(valExpression, facesContext, componentType);
    }

    public final Converter createConverter(String converterId) {
        this.checkNull(converterId, "converterId");
        this.checkEmpty(converterId, "converterId");
        Class<?> converterClass = this.getObjectFromClassMap(converterId, this._converterIdToClassMap);
        if (converterClass == null) {
            throw new FacesException("Could not find any registered converter-class by converterId : " + converterId);
        }
        try {
            Converter converter = (Converter)converterClass.newInstance();
            this.setConverterProperties(converterClass, converter);
            this._handleAttachedResourceDependencyAnnotations(FacesContext.getCurrentInstance(), converter);
            return converter;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate converter " + converterClass, e);
            throw new FacesException("Could not instantiate converter: " + converterClass, (Throwable)e);
        }
    }

    public final Converter createConverter(Class<?> targetClass) {
        this.checkNull(targetClass, "targetClass");
        return this.internalCreateConverter(targetClass);
    }

    private Converter internalCreateConverter(Class<?> targetClass) {
        Class<?>[] interfaces;
        Object converterClassOrClassName = this._converterTargetClassToConverterClassMap.get(targetClass);
        if (converterClassOrClassName == null && !String.class.equals(targetClass) && (interfaces = targetClass.getInterfaces()) != null) {
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Converter converter = this.internalCreateConverter(interfaces[i]);
                if (converter == null) continue;
                return converter;
            }
        }
        if (converterClassOrClassName == null && targetClass.isEnum()) {
            converterClassOrClassName = this._converterTargetClassToConverterClassMap.get(Enum.class);
        }
        if (converterClassOrClassName != null) {
            try {
                Class converterClass = null;
                if (converterClassOrClassName instanceof Class) {
                    converterClass = (Class)converterClassOrClassName;
                } else if (converterClassOrClassName instanceof String) {
                    converterClass = ClassUtils.simpleClassForName((String)converterClassOrClassName);
                    this._converterTargetClassToConverterClassMap.put(targetClass, converterClass);
                } else {
                    this._converterTargetClassToConverterClassMap.remove(targetClass);
                }
                Converter converter = null;
                if (!this._noArgConstructorConverterClasses.contains(converterClass)) {
                    try {
                        Constructor constructor = converterClass.getConstructor(Class.class);
                        converter = (Converter)constructor.newInstance(targetClass);
                    }
                    catch (Exception e) {
                        this._noArgConstructorConverterClasses.add(converterClass);
                        converter = (Converter)converterClass.newInstance();
                    }
                } else {
                    converter = (Converter)converterClass.newInstance();
                }
                this.setConverterProperties(converterClass, converter);
                return converter;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not instantiate converter " + converterClassOrClassName.toString(), e);
                throw new FacesException("Could not instantiate converter: " + converterClassOrClassName.toString(), (Throwable)e);
            }
        }
        if (targetClass == Long.TYPE) {
            return this.internalCreateConverter(Long.class);
        }
        if (targetClass == Boolean.TYPE) {
            return this.internalCreateConverter(Boolean.class);
        }
        if (targetClass == Double.TYPE) {
            return this.internalCreateConverter(Double.class);
        }
        if (targetClass == Byte.TYPE) {
            return this.internalCreateConverter(Byte.class);
        }
        if (targetClass == Short.TYPE) {
            return this.internalCreateConverter(Short.class);
        }
        if (targetClass == Integer.TYPE) {
            return this.internalCreateConverter(Integer.class);
        }
        if (targetClass == Float.TYPE) {
            return this.internalCreateConverter(Float.class);
        }
        if (targetClass == Character.TYPE) {
            return this.internalCreateConverter(Character.class);
        }
        Class<?> superClazz = targetClass.getSuperclass();
        return superClazz != null ? this.internalCreateConverter(superClazz) : null;
    }

    private void setConverterProperties(Class<?> converterClass, Converter converter) {
        org.apache.myfaces.config.element.Converter converterConfig = this._runtimeConfig.getConverterConfiguration(converterClass.getName());
        if (converter instanceof DateTimeConverter && this._dateTimeConverterDefaultTimeZoneIsSystemTimeZone) {
            ((DateTimeConverter)converter).setTimeZone(TimeZone.getDefault());
        }
        if (converterConfig != null && converterConfig.getProperties().size() > 0) {
            for (Property property : converterConfig.getProperties()) {
                try {
                    BeanUtils.setProperty((Object)converter, (String)property.getPropertyName(), (Object)property.getDefaultValue());
                }
                catch (Throwable th) {
                    log.log(Level.SEVERE, "Initializing converter : " + converterClass.getName() + " with property : " + property.getPropertyName() + " and value : " + property.getDefaultValue() + " failed.");
                }
            }
        }
    }

    private void _handleAttachedResourceDependencyAnnotations(FacesContext context, Object inspected) {
        Class<?> inspectedClass;
        if (inspected == null) {
            return;
        }
        RequestViewContext rvc = RequestViewContext.getCurrentInstance(context);
        if (rvc.isClassAlreadyProcessed(inspectedClass = inspected.getClass())) {
            return;
        }
        boolean classAlreadyProcessed = false;
        List<Object> dependencyList = null;
        boolean isCachedList = false;
        if (context.isProjectStage(ProjectStage.Production) && this._classToResourceDependencyMap.containsKey(inspectedClass)) {
            dependencyList = this._classToResourceDependencyMap.get(inspectedClass);
            if (dependencyList == null) {
                return;
            }
            if (dependencyList.isEmpty()) {
                return;
            }
            isCachedList = true;
        }
        if (dependencyList == null) {
            ResourceDependency dependency = inspectedClass.getAnnotation(ResourceDependency.class);
            ResourceDependencies dependencies = inspectedClass.getAnnotation(ResourceDependencies.class);
            if (dependency != null || dependencies != null) {
                dependencyList = new ArrayList<ResourceDependency>();
                if (dependency != null) {
                    dependencyList.add(dependency);
                }
                if (dependencies != null) {
                    dependencyList.addAll(Arrays.asList(dependencies.value()));
                }
            } else {
                dependencyList = Collections.emptyList();
            }
        }
        if (dependencyList != null && !dependencyList.isEmpty()) {
            int size = dependencyList.size();
            for (int i = 0; i < size; ++i) {
                ResourceDependency dependency = dependencyList.get(i);
                if (rvc.isResourceDependencyAlreadyProcessed(dependency)) continue;
                this._handleAttachedResourceDependency(context, dependency);
                rvc.setResourceDependencyAsProcessed(dependency);
            }
        }
        if (context.isProjectStage(ProjectStage.Production) && !isCachedList && dependencyList != null) {
            this._classToResourceDependencyMap.put(inspectedClass, dependencyList);
        }
        if (!classAlreadyProcessed) {
            rvc.setClassProcessed(inspectedClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResourceIdOnFaceletsMode(FacesContext facesContext, UIComponent component) {
        FaceletCompositionContext mctx;
        if (component.getId() == null && (mctx = FaceletCompositionContext.getCurrentInstance(facesContext)) != null) {
            UIViewRoot root = facesContext.getViewRoot();
            root.getAttributes().put(RESOURCE_DEPENDENCY_UNIQUE_ID_KEY, Boolean.TRUE);
            try {
                String uid = root.createUniqueId(facesContext, null);
                component.setId(uid);
            }
            finally {
                root.getAttributes().put(RESOURCE_DEPENDENCY_UNIQUE_ID_KEY, Boolean.FALSE);
            }
        }
    }

    private void _handleAttachedResourceDependency(FacesContext context, ResourceDependency annotation) {
        if (annotation != null) {
            String target;
            Application application = context.getApplication();
            UIOutput output = (UIOutput)application.createComponent(context, "javax.faces.Output", null);
            String name = annotation.name();
            if (name != null && name.length() > 0) {
                name = ELText.parse(this.getExpressionFactory(), context.getELContext(), name).toString(context.getELContext());
            }
            String rendererType = application.getResourceHandler().getRendererTypeForResourceName(name);
            output.setRendererType(rendererType);
            this.setResourceIdOnFaceletsMode(context, (UIComponent)output);
            Map attributes = output.getAttributes();
            attributes.put("name", name);
            String library = annotation.library();
            if (library != null && library.length() > 0) {
                library = ELText.parse(this.getExpressionFactory(), context.getELContext(), library).toString(context.getELContext());
                attributes.put("library", library);
            }
            if ((target = annotation.target()) != null && target.length() > 0) {
                target = ELText.parse(this.getExpressionFactory(), context.getELContext(), target).toString(context.getELContext());
                attributes.put("target", target);
                context.getViewRoot().addComponentResource(context, (UIComponent)output, target);
            } else {
                context.getViewRoot().addComponentResource(context, (UIComponent)output);
            }
        }
    }

    @Deprecated
    public final MethodBinding createMethodBinding(String reference, Class<?>[] params) throws ReferenceSyntaxException {
        MethodExpression methodExpression;
        this.checkNull(reference, "reference");
        this.checkEmpty(reference, "reference");
        if (!reference.startsWith("#{") || !reference.endsWith("}")) {
            throw new ReferenceSyntaxException("Invalid method reference: '" + reference + "'");
        }
        if (params == null) {
            params = new Class[]{};
        }
        try {
            methodExpression = this.getExpressionFactory().createMethodExpression(this.threadELContext(), reference, Object.class, (Class[])params);
        }
        catch (ELException e) {
            throw new ReferenceSyntaxException((Throwable)e);
        }
        return new MethodExpressionToMethodBinding(methodExpression);
    }

    public final Validator createValidator(String validatorId) throws FacesException {
        this.checkNull(validatorId, "validatorId");
        this.checkEmpty(validatorId, "validatorId");
        Class<?> validatorClass = this.getObjectFromClassMap(validatorId, this._validatorClassMap);
        if (validatorClass == null) {
            String message = "Unknown validator id '" + validatorId + "'.";
            log.severe(message);
            throw new FacesException(message);
        }
        try {
            Validator validator = (Validator)validatorClass.newInstance();
            this._handleAttachedResourceDependencyAnnotations(FacesContext.getCurrentInstance(), validator);
            return validator;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate validator " + validatorClass, e);
            throw new FacesException("Could not instantiate validator: " + validatorClass, (Throwable)e);
        }
    }

    public final ValueBinding createValueBinding(String reference) throws ReferenceSyntaxException {
        ValueExpression valueExpression;
        this.checkNull(reference, "reference");
        this.checkEmpty(reference, "reference");
        try {
            valueExpression = this.getExpressionFactory().createValueExpression(this.threadELContext(), reference, Object.class);
        }
        catch (ELException e) {
            throw new ReferenceSyntaxException((Throwable)e);
        }
        return new ValueExpressionToValueBinding(valueExpression);
    }

    private final ELContext threadELContext() {
        return this.getFaceContext().getELContext();
    }

    public final String getDefaultRenderKitId() {
        return this._defaultRenderKitId;
    }

    public final void setDefaultRenderKitId(String defaultRenderKitId) {
        this._defaultRenderKitId = defaultRenderKitId;
    }

    public final StateManager getStateManager() {
        return this._stateManager;
    }

    public final void setStateManager(StateManager stateManager) {
        this.checkNull(stateManager, "stateManager");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setStateManager may not be executed after a lifecycle request has been completed");
        }
        this._stateManager = stateManager;
    }

    private void checkNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException(paramName + " cannot be null.");
        }
    }

    private void checkEmpty(String param, String paramName) {
        if (param.length() == 0) {
            throw new NullPointerException("String " + paramName + " cannot be empty.");
        }
    }

    private static SystemEvent _createEvent(Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (event == null) {
            try {
                Constructor<?>[] constructors = systemEventClass.getConstructors();
                Constructor<?> constructor = null;
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length != 1) continue;
                    constructor = c;
                    break;
                }
                if (constructor != null) {
                    event = (SystemEvent)constructor.newInstance(source);
                }
            }
            catch (Exception e) {
                throw new FacesException("Couldn't instanciate system event of type " + systemEventClass.getName(), (Throwable)e);
            }
        }
        return event;
    }

    private void _handleAnnotations(FacesContext context, Object inspected, UIComponent component) {
        boolean isProduction = context.isProjectStage(ProjectStage.Production);
        Class<?> inspectedClass = inspected.getClass();
        this._handleListenerForAnnotations(context, inspected, inspectedClass, component, isProduction);
        this._handleResourceDependencyAnnotations(context, inspectedClass, component, isProduction);
    }

    private void _handleListenerForAnnotations(FacesContext context, Object inspected, Class<?> inspectedClass, UIComponent component, boolean isProduction) {
        List<Object> listenerForList = null;
        boolean isCachedList = false;
        if (isProduction && this._classToListenerForMap.containsKey(inspectedClass)) {
            listenerForList = this._classToListenerForMap.get(inspectedClass);
            if (listenerForList == null) {
                return;
            }
            if (listenerForList.isEmpty()) {
                return;
            }
            isCachedList = true;
        }
        if (listenerForList == null) {
            ListenerFor listener = inspectedClass.getAnnotation(ListenerFor.class);
            ListenersFor listeners = inspectedClass.getAnnotation(ListenersFor.class);
            if (listener != null || listeners != null) {
                listenerForList = new ArrayList<ListenerFor>();
                if (listener != null) {
                    listenerForList.add(listener);
                }
                if (listeners != null) {
                    listenerForList.addAll(Arrays.asList(listeners.value()));
                }
            } else {
                listenerForList = Collections.emptyList();
            }
        }
        if (listenerForList != null && !listenerForList.isEmpty()) {
            int size = listenerForList.size();
            for (int i = 0; i < size; ++i) {
                ListenerFor listenerFor = listenerForList.get(i);
                this._handleListenerFor(context, inspected, component, listenerFor);
            }
        }
        if (isProduction && !isCachedList && listenerForList != null) {
            this._classToListenerForMap.put(inspectedClass, listenerForList);
        }
    }

    private void _handleListenerFor(FacesContext context, Object inspected, UIComponent component, ListenerFor annotation) {
        if (annotation != null) {
            if (inspected instanceof ComponentSystemEventListener) {
                component.subscribeToEvent(annotation.systemEventClass(), (ComponentSystemEventListener)inspected);
            } else if (component instanceof SystemEventListener) {
                Application application = context.getApplication();
                if (Void.class.equals((Object)annotation.sourceClass())) {
                    application.subscribeToEvent(annotation.systemEventClass(), (SystemEventListener)inspected);
                } else {
                    application.subscribeToEvent(annotation.systemEventClass(), annotation.sourceClass(), (SystemEventListener)inspected);
                }
            }
        }
    }

    private void _handleResourceDependencyAnnotations(FacesContext context, Class<?> inspectedClass, UIComponent component, boolean isProduction) {
        RequestViewContext rvc = RequestViewContext.getCurrentInstance(context);
        if (rvc.isClassAlreadyProcessed(inspectedClass)) {
            return;
        }
        boolean classAlreadyProcessed = false;
        List<Object> dependencyList = null;
        boolean isCachedList = false;
        if (isProduction && this._classToResourceDependencyMap.containsKey(inspectedClass)) {
            dependencyList = this._classToResourceDependencyMap.get(inspectedClass);
            if (dependencyList == null) {
                return;
            }
            if (dependencyList.isEmpty()) {
                return;
            }
            isCachedList = true;
        }
        if (dependencyList == null) {
            ResourceDependency dependency = inspectedClass.getAnnotation(ResourceDependency.class);
            ResourceDependencies dependencies = inspectedClass.getAnnotation(ResourceDependencies.class);
            if (dependency != null || dependencies != null) {
                dependencyList = new ArrayList<ResourceDependency>();
                if (dependency != null) {
                    dependencyList.add(dependency);
                }
                if (dependencies != null) {
                    dependencyList.addAll(Arrays.asList(dependencies.value()));
                }
            } else {
                dependencyList = Collections.emptyList();
            }
        }
        if (dependencyList != null && !dependencyList.isEmpty()) {
            int size = dependencyList.size();
            for (int i = 0; i < size; ++i) {
                ResourceDependency dependency = dependencyList.get(i);
                if (rvc.isResourceDependencyAlreadyProcessed(dependency)) continue;
                this._handleResourceDependency(context, component, dependency);
                rvc.setResourceDependencyAsProcessed(dependency);
            }
        }
        if (isProduction && !isCachedList && dependencyList != null) {
            this._classToResourceDependencyMap.put(inspectedClass, dependencyList);
        }
        if (!classAlreadyProcessed) {
            rvc.setClassProcessed(inspectedClass);
        }
    }

    private void _handleResourceDependency(FacesContext context, UIComponent component, ResourceDependency annotation) {
        if (annotation != null) {
            String target;
            UIOutput output = (UIOutput)this.createComponent(context, "javax.faces.Output", null);
            String name = annotation.name();
            if (name != null && name.length() > 0) {
                name = ELText.parse(this.getExpressionFactory(), context.getELContext(), name).toString(context.getELContext());
            }
            String rendererType = context.getApplication().getResourceHandler().getRendererTypeForResourceName(name);
            output.setRendererType(rendererType);
            this.setResourceIdOnFaceletsMode(context, (UIComponent)output);
            Map attributes = output.getAttributes();
            attributes.put("name", name);
            String library = annotation.library();
            if (library != null && library.length() > 0) {
                library = ELText.parse(this.getExpressionFactory(), context.getELContext(), library).toString(context.getELContext());
                if ("this".equals(library)) {
                    Resource resource = (Resource)component.getAttributes().get("javax.faces.application.Resource.ComponentResource");
                    if (resource != null) {
                        attributes.put("library", resource.getLibraryName());
                    }
                } else {
                    attributes.put("library", library);
                }
            }
            if ((target = annotation.target()) != null && target.length() > 0) {
                target = ELText.parse(this.getExpressionFactory(), context.getELContext(), target).toString(context.getELContext());
                attributes.put("target", target);
                context.getViewRoot().addComponentResource(context, (UIComponent)output, target);
            } else {
                context.getViewRoot().addComponentResource(context, (UIComponent)output);
            }
        }
    }

    private void _inspectRenderer(FacesContext context, UIComponent component, String componentType, String rendererType) {
        Renderer renderer = context.getRenderKit().getRenderer(component.getFamily(), rendererType);
        if (renderer == null) {
            log.severe("renderer cannot be found for component type " + componentType + " and renderer type " + rendererType);
        } else {
            component.setRendererType(rendererType);
            this._handleAnnotations(context, renderer, component);
        }
    }

    private static SystemEvent _traverseListenerList(List<? extends SystemEventListener> listeners, Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (listeners != null && !listeners.isEmpty()) {
            int size = listeners.size();
            for (int i = 0; i < size; ++i) {
                SystemEventListener listener = listeners.get(i);
                if (!listener.isListenerForSource(source) || !(event = ApplicationImpl._createEvent(systemEventClass, source, event)).isAppropriateListener((FacesListener)listener)) continue;
                event.processListener((FacesListener)listener);
            }
        }
        return event;
    }

    private static SystemEvent _traverseListenerListWithCopy(List<? extends SystemEventListener> listeners, Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (listeners != null && !listeners.isEmpty()) {
            ArrayList<SystemEventListener> listenersCopy = new ArrayList<SystemEventListener>();
            int processedListenerIndex = 0;
            for (int i = 0; i < listeners.size(); ++i) {
                listenersCopy.add(listeners.get(i));
            }
            while (processedListenerIndex < listenersCopy.size()) {
                int i;
                while (processedListenerIndex < listenersCopy.size()) {
                    SystemEventListener listener = (SystemEventListener)listenersCopy.get(processedListenerIndex);
                    if (listener.isListenerForSource(source) && (event = ApplicationImpl._createEvent(systemEventClass, source, event)).isAppropriateListener((FacesListener)listener)) {
                        event.processListener((FacesListener)listener);
                    }
                    ++processedListenerIndex;
                }
                boolean listChanged = false;
                if (listeners.size() == listenersCopy.size()) {
                    for (i = 0; i < listenersCopy.size(); ++i) {
                        if (listenersCopy.get(i) == listeners.get(i)) continue;
                        listChanged = true;
                        break;
                    }
                } else {
                    listChanged = true;
                }
                if (!listChanged) continue;
                for (i = 0; i < listeners.size(); ++i) {
                    SystemEventListener listener = listeners.get(i);
                    if (i < listenersCopy.size()) {
                        if (listener.equals(listenersCopy.get(i)) || listenersCopy.contains(listener)) continue;
                        listenersCopy.add(listener);
                        continue;
                    }
                    if (listenersCopy.contains(listener)) continue;
                    listenersCopy.add(listener);
                }
            }
        }
        return event;
    }

    private boolean isFirstRequestProcessed() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!this._firstRequestProcessed && context != null && Boolean.TRUE.equals(context.getExternalContext().getApplicationMap().containsKey("org.apache.myfaces.lifecycle.first.request.processed"))) {
            this._firstRequestProcessed = true;
        }
        return this._firstRequestProcessed;
    }

    private Class<?> getObjectFromClassMap(String id, Map<String, Object> classMap) {
        Object obj = classMap.get(id);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String) {
            Class clazz = ClassUtils.simpleClassForName((String)obj);
            classMap.put(id, clazz);
            return clazz;
        }
        classMap.remove(id);
        return null;
    }

    private boolean isLazyLoadConfigObjects() {
        if (this._lazyLoadConfigObjects == null) {
            String configParam = this.getFaceContext().getExternalContext().getInitParameter(LAZY_LOAD_CONFIG_OBJECTS_PARAM_NAME);
            this._lazyLoadConfigObjects = configParam == null ? true : Boolean.parseBoolean(configParam);
        }
        return this._lazyLoadConfigObjects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SystemListenerEntry {
        private List<SystemEventListener> _lstSystemEventListener;
        private Map<Class<?>, List<SystemEventListener>> _sourceClassMap;

        public void addListener(SystemEventListener listener) {
            assert (listener != null);
            this.addListenerNoDuplicate(this.getAnySourceListenersNotNull(), listener);
        }

        public void addListener(SystemEventListener listener, Class<?> source) {
            assert (listener != null);
            if (source == null) {
                this.addListener(listener);
            } else {
                this.addListenerNoDuplicate(this.getSpecificSourceListenersNotNull(source), listener);
            }
        }

        public void removeListener(SystemEventListener listener) {
            assert (listener != null);
            if (this._lstSystemEventListener != null) {
                this._lstSystemEventListener.remove(listener);
            }
        }

        public void removeListener(SystemEventListener listener, Class<?> sourceClass) {
            List<SystemEventListener> listeners;
            assert (listener != null);
            if (sourceClass == null) {
                this.removeListener(listener);
            } else if (this._sourceClassMap != null && (listeners = this._sourceClassMap.get(sourceClass)) != null) {
                listeners.remove(listener);
            }
        }

        public void publish(Class<? extends SystemEvent> systemEventClass, Class<?> classSource, Object source, SystemEvent event) {
            if (source != null && this._sourceClassMap != null) {
                event = ApplicationImpl._traverseListenerList(this._sourceClassMap.get(classSource), systemEventClass, source, event);
            }
            ApplicationImpl._traverseListenerList(this._lstSystemEventListener, systemEventClass, source, event);
        }

        private void addListenerNoDuplicate(List<SystemEventListener> listeners, SystemEventListener listener) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }

        private synchronized List<SystemEventListener> getAnySourceListenersNotNull() {
            if (this._lstSystemEventListener == null) {
                this._lstSystemEventListener = new CopyOnWriteArrayList<SystemEventListener>();
            }
            return this._lstSystemEventListener;
        }

        private synchronized List<SystemEventListener> getSpecificSourceListenersNotNull(Class<?> sourceClass) {
            List<SystemEventListener> list;
            if (this._sourceClassMap == null) {
                this._sourceClassMap = new ConcurrentHashMap();
            }
            if ((list = this._sourceClassMap.get(sourceClass)) == null) {
                list = new CopyOnWriteArrayList<SystemEventListener>();
                this._sourceClassMap.put(sourceClass, list);
            }
            return list;
        }
    }
}

