/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.convert.Converter;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;

public final class ValueHolderRule
extends MetaRule {
    public static final ValueHolderRule INSTANCE = new ValueHolderRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(ValueHolder.class)) {
            if ("converter".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralConverterMetadata(attribute.getValue());
                }
                return new DynamicConverterMetadata2(attribute);
            }
            if ("value".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralValueMetadata(attribute.getValue());
                }
                return new DynamicValueExpressionMetadata(attribute);
            }
        }
        return null;
    }

    static final class DynamicValueExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public DynamicValueExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("value", this.attr.getValueExpression(ctx, Object.class));
        }
    }

    static final class LiteralValueMetadata
    extends Metadata {
        private final String value;

        public LiteralValueMetadata(String value) {
            this.value = value;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setValue((Object)this.value);
        }
    }

    static final class DynamicConverterMetadata2
    extends Metadata {
        private final TagAttribute attr;

        public DynamicConverterMetadata2(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("converter", this.attr.getValueExpression(ctx, Converter.class));
        }
    }

    static final class LiteralConverterMetadata
    extends Metadata {
        private final String converterId;

        public LiteralConverterMetadata(String converterId) {
            this.converterId = converterId;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setConverter(ctx.getFacesContext().getApplication().createConverter(this.converterId));
        }
    }
}

