/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.annotation.FacesConfig;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import org.apache.myfaces.cdi.config.FacesConfigBeanHolder;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.el.convert.PropertyResolverToELResolver;
import org.apache.myfaces.el.convert.VariableResolverToELResolver;
import org.apache.myfaces.el.unified.resolver.FacesCompositeELResolver;
import org.apache.myfaces.shared.config.MyfacesConfig;

public class ResolverBuilderBase {
    private static final Logger log = Logger.getLogger(ResolverBuilderBase.class.getName());
    public static final String EL_RESOLVER_COMPARATOR = "org.apache.myfaces.EL_RESOLVER_COMPARATOR";
    public static final String EL_RESOLVER_PREDICATE = "org.apache.myfaces.EL_RESOLVER_PREDICATE";
    private final RuntimeConfig _config;

    public ResolverBuilderBase(RuntimeConfig config) {
        this._config = config;
    }

    protected void addFromRuntimeConfig(List<ELResolver> resolvers) {
        FacesContext facesContext;
        if (this._config.getFacesConfigElResolvers() != null) {
            for (ELResolver resolver : this._config.getFacesConfigElResolvers()) {
                resolvers.add(resolver);
            }
        }
        if ((facesContext = FacesContext.getCurrentInstance()) == null) {
            if (this._config.getVariableResolver() != null) {
                resolvers.add(this.createELResolver(this._config.getVariableResolver()));
            } else if (this._config.getVariableResolverChainHead() != null) {
                resolvers.add(this.createELResolver(this._config.getVariableResolverChainHead()));
            }
            if (this._config.getPropertyResolver() != null) {
                resolvers.add(this.createELResolver(this._config.getPropertyResolver()));
            } else if (this._config.getPropertyResolverChainHead() != null) {
                resolvers.add(this.createELResolver(this._config.getPropertyResolverChainHead()));
            }
        } else if (facesContext != null && MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isSupportJSPAndFacesEL()) {
            if (this._config.getVariableResolver() != null) {
                resolvers.add(this.createELResolver(this._config.getVariableResolver()));
            } else if (this._config.getVariableResolverChainHead() != null) {
                resolvers.add(this.createELResolver(this._config.getVariableResolverChainHead()));
            }
            if (this._config.getPropertyResolver() != null) {
                resolvers.add(this.createELResolver(this._config.getPropertyResolver()));
            } else if (this._config.getPropertyResolverChainHead() != null) {
                resolvers.add(this.createELResolver(this._config.getPropertyResolverChainHead()));
            }
        }
        if (this._config.getApplicationElResolvers() != null) {
            for (ELResolver resolver : this._config.getApplicationElResolvers()) {
                resolvers.add(resolver);
            }
        }
    }

    protected void sortELResolvers(List<ELResolver> resolvers, FacesCompositeELResolver.Scope scope) {
        if (this._config.getELResolverComparator() != null) {
            try {
                Collections.sort(resolvers, this._config.getELResolverComparator());
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Chain of EL resolvers for {0} sorted with: {1} and the result order is {2}", new Object[]{scope, this._config.getELResolverComparator(), resolvers});
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not sort ELResolvers with custom Comparator", e);
            }
        }
    }

    protected Iterable<ELResolver> filterELResolvers(List<ELResolver> resolvers, FacesCompositeELResolver.Scope scope) {
        Predicate<ELResolver> predicate = this._config.getELResolverPredicate();
        if (predicate != null) {
            try {
                resolvers.removeIf(elResolver -> !predicate.test((ELResolver)elResolver));
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Chain of EL resolvers for {0} filtered with: {1} and the result is {2}", new Object[]{scope, predicate, resolvers});
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not filter ELResolvers with custom Predicate", e);
            }
        }
        return resolvers;
    }

    protected ELResolver createELResolver(VariableResolver resolver) {
        return new VariableResolverToELResolver(resolver);
    }

    protected ELResolver createELResolver(PropertyResolver resolver) {
        return new PropertyResolverToELResolver(resolver);
    }

    protected RuntimeConfig getRuntimeConfig() {
        return this._config;
    }

    protected boolean isReplaceImplicitObjectResolverWithCDIResolver(FacesContext facesContext) {
        FacesConfigBeanHolder holder;
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
        if (beanManager != null && (holder = CDIUtils.lookup(beanManager, FacesConfigBeanHolder.class)) != null) {
            FacesConfig.Version version = holder.getFacesConfigVersion();
            if (version == null) {
                return false;
            }
            return version.ordinal() >= FacesConfig.Version.JSF_2_3.ordinal();
        }
        return false;
    }
}

