/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.component.EscapeCapable;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlLabelRenderer
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlLabelRenderer.class.getName());
    private static final Set<SearchExpressionHint> EXPRESSION_HINTS = EnumSet.of(SearchExpressionHint.RESOLVE_SINGLE_COMPONENT, SearchExpressionHint.IGNORE_NO_RESULT);

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String text;
        super.encodeBegin(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        this.encodeBefore(facesContext, writer, uiComponent);
        writer.startElement("label", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder) {
            if (!behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            }
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, uiComponent);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(uiComponent);
                CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderLabelPassthroughPropertiesWithoutEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.LABEL_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderLabelPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.LABEL_PASSTHROUGH_ATTRIBUTES);
            }
        }
        String forAttr = this.getFor(uiComponent);
        if (forAttr != null) {
            writer.writeAttribute("for", (Object)this.getClientId(facesContext, uiComponent, forAttr), "for");
        } else if (log.isLoggable(Level.WARNING)) {
            log.warning("Attribute 'for' of label component with id " + uiComponent.getClientId(facesContext) + " is not defined");
        }
        if (uiComponent instanceof ValueHolder && (text = RendererUtils.getStringValue(facesContext, uiComponent)) != null) {
            boolean escape = uiComponent instanceof HtmlOutputLabel || uiComponent instanceof EscapeCapable ? ((HtmlOutputLabel)uiComponent).isEscape() : RendererUtils.getBooleanAttribute(uiComponent, "escape", true);
            if (escape) {
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
        }
        writer.flush();
        this.encodeAfterStart(facesContext, writer, uiComponent);
    }

    protected void encodeAfterStart(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected void encodeBefore(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected String getFor(UIComponent component) {
        if (component instanceof HtmlOutputLabel) {
            return ((HtmlOutputLabel)component).getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    protected String getClientId(FacesContext facesContext, UIComponent uiComponent, String forAttr) {
        SearchExpressionContext searchExpressionContext = SearchExpressionContext.createSearchExpressionContext((FacesContext)facesContext, (UIComponent)uiComponent, EXPRESSION_HINTS, null);
        return facesContext.getApplication().getSearchExpressionHandler().resolveClientId(searchExpressionContext, forAttr);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encodeBeforeEnd(facesContext, writer, uiComponent);
        writer.endElement("label");
        this.encodeAfter(facesContext, writer, uiComponent);
    }

    protected void encodeBeforeEnd(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected void encodeAfter(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }
}

