/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.context.FacesContext;
import org.apache.myfaces.push.cdi.CsrfSessionTokenFactory;
import org.apache.myfaces.push.cdi.RandomCsrfSessionTokenFactory;
import org.apache.myfaces.push.cdi.SecureRandomCsrfSessionTokenFactory;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

@ApplicationScoped
public class WebsocketChannelTokenBuilderBean {
    private static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN";
    private static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_PARAM_DEFAULT = "random";
    private static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_SECURE_RANDOM = "secureRandom";
    private static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_RANDOM = "random";
    private CsrfSessionTokenFactory csrfSessionTokenFactory;
    private boolean initialized;

    @PostConstruct
    public void init() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            this.internalInit(facesContext);
        }
    }

    private synchronized void internalInit(FacesContext facesContext) {
        String csrfRandomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_PARAM, "random");
        this.csrfSessionTokenFactory = RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_SECURE_RANDOM.equals(csrfRandomMode) ? new SecureRandomCsrfSessionTokenFactory(facesContext) : new RandomCsrfSessionTokenFactory(facesContext);
        this.initialized = true;
    }

    public String createChannelToken(FacesContext facesContext, String channel) {
        if (!this.initialized) {
            this.internalInit(facesContext);
        }
        return this.csrfSessionTokenFactory.createCryptographicallyStrongTokenFromSession(facesContext);
    }
}

