/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import jakarta.resource.spi.TransactionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.jboss.as.connector.deployers.ra.ConnectionFactoryDefinitionInjectionSource;
import org.jboss.as.connector.services.resourceadapters.ConnectionFactoryReferenceFactoryService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ExternalBrokerConfigurationService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemRootResourceDefinition;
import org.wildfly.extension.messaging.activemq.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSConnectionFactoryDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private String interfaceName;
    private String className;
    private String resourceAdapter;
    private String user;
    private String password;
    private String clientId;
    private boolean transactional;
    private int maxPoolSize;
    private int minPoolSize;
    private boolean legacySecurityAvailable;

    public JMSConnectionFactoryDefinitionInjectionSource(String jndiName) {
        super(jndiName);
    }

    void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    void setUser(String user) {
        this.user = user;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setLegacySecurityAvailable(boolean legacySecurityAvailable) {
        this.legacySecurityAvailable = legacySecurityAvailable;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        boolean external;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (this.resourceAdapter == null || this.resourceAdapter.isEmpty()) {
            this.resourceAdapter = JMSConnectionFactoryDefinitionInjectionSource.getDefaulResourceAdapter(deploymentUnit);
        }
        if ((external = JMSConnectionFactoryDefinitionInjectionSource.targetsExternalPooledConnectionFactory(this.resourceAdapter, phaseContext.getServiceRegistry())) || JMSConnectionFactoryDefinitionInjectionSource.targetsPooledConnectionFactory(JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties), this.resourceAdapter, phaseContext.getServiceRegistry())) {
            try {
                this.startedPooledConnectionFactory(context, this.jndiName, serviceBuilder, phaseContext.getServiceTarget(), deploymentUnit, injector, external);
            }
            catch (OperationFailedException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        } else {
            ConnectionFactoryDefinitionInjectionSource cfdis = new ConnectionFactoryDefinitionInjectionSource(this.jndiName, this.interfaceName, this.resourceAdapter);
            cfdis.setMaxPoolSize(this.maxPoolSize);
            cfdis.setMinPoolSize(this.minPoolSize);
            cfdis.setTransactionSupportLevel(this.transactional ? TransactionSupport.TransactionSupportLevel.XATransaction : TransactionSupport.TransactionSupportLevel.NoTransaction);
            cfdis.setLegacySecurityAvailable(this.legacySecurityAvailable);
            for (Map.Entry property : this.properties.entrySet()) {
                cfdis.addProperty((String)property.getKey(), (String)property.getValue());
            }
            if (!this.user.isEmpty()) {
                cfdis.addProperty("user", this.user);
            }
            if (!this.password.isEmpty()) {
                cfdis.addProperty("password", this.password);
            }
            if (!this.clientId.isEmpty()) {
                cfdis.addProperty("clientId", this.clientId);
            }
            cfdis.getResourceValue(context, serviceBuilder, phaseContext, injector);
        }
    }

    private void startedPooledConnectionFactory(InjectionSource.ResolutionContext context, String name, ServiceBuilder<?> serviceBuilder, ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector, boolean external) throws DeploymentUnitProcessingException, OperationFailedException {
        PathAddress registration;
        String serverName;
        String managedConnectionPoolClassName;
        String string;
        String discoveryGroupName;
        HashMap<String, String> props = new HashMap<String, String>(this.properties);
        List<String> connectors = this.getConnectors(props);
        this.clearUnknownProperties(this.properties);
        ModelNode model = new ModelNode();
        for (String string2 : connectors) {
            model.get("connectors").add(string2);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            model.get((String)entry.getKey()).set((String)entry.getValue());
        }
        model.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).set(this.minPoolSize);
        model.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).set(this.maxPoolSize);
        if (this.user != null && !this.user.isEmpty()) {
            model.get(ConnectionFactoryAttributes.Pooled.USER.getName()).set(this.user);
        }
        if (this.password != null && !this.password.isEmpty()) {
            model.get(ConnectionFactoryAttributes.Pooled.PASSWORD.getName()).set(this.password);
        }
        if (this.clientId != null && !this.clientId.isEmpty()) {
            model.get(CommonAttributes.CLIENT_ID.getName()).set(this.clientId);
        }
        String string3 = discoveryGroupName = this.properties.containsKey(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()) ? (String)this.properties.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()) : null;
        if (discoveryGroupName != null) {
            model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()).set(discoveryGroupName);
        }
        String string4 = string = this.properties.containsKey(CommonAttributes.JGROUPS_CLUSTER.getName()) ? (String)this.properties.get(CommonAttributes.JGROUPS_CLUSTER.getName()) : null;
        if (string != null) {
            model.get(CommonAttributes.JGROUPS_CLUSTER.getName()).set(string);
        }
        String string5 = managedConnectionPoolClassName = this.properties.containsKey(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()) ? (String)this.properties.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()) : null;
        if (managedConnectionPoolClassName != null) {
            model.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()).set(managedConnectionPoolClassName);
        }
        Boolean enlistmentTrace = this.properties.containsKey(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName()) ? Boolean.valueOf((String)this.properties.get(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName())) : null;
        List<PooledConnectionFactoryConfigProperties> adapterParams = this.getAdapterParams(model);
        String txSupport = this.transactional ? "XATransaction" : "NoTransaction";
        String pcfName = JMSConnectionFactoryDefinitionInjectionSource.uniqueName(context, name);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)name);
        if (external) {
            serverName = null;
            HashSet<String> connectorsSocketBindings = new HashSet<String>();
            HashSet<String> sslContextNames = new HashSet<String>();
            ExternalBrokerConfigurationService configuration = (ExternalBrokerConfigurationService)deploymentUnit.getServiceRegistry().getRequiredService(MessagingSubsystemRootResourceDefinition.CONFIGURATION_CAPABILITY.getCapabilityServiceName()).getService().getValue();
            TransportConfiguration[] tcs = new TransportConfiguration[connectors.size()];
            for (int i = 0; i < tcs.length; ++i) {
                tcs[i] = configuration.getConnectors().get(connectors.get(i));
                if (tcs[i].getParams().containsKey("socket-binding")) {
                    connectorsSocketBindings.add(tcs[i].getParams().get("socket-binding").toString());
                }
                if (!tcs[i].getParams().containsKey("ssl-context")) continue;
                sslContextNames.add(tcs[i].getParams().get("ssl-context").toString());
            }
            DiscoveryGroupConfiguration discoveryGroupConfiguration = null;
            if (discoveryGroupName != null) {
                discoveryGroupConfiguration = configuration.getDiscoveryGroupConfigurations().get(discoveryGroupName);
            }
            if (connectors.isEmpty() && discoveryGroupConfiguration == null) {
                tcs = JMSConnectionFactoryDefinitionInjectionSource.getExternalPooledConnectionFactory(this.resourceAdapter, deploymentUnit.getServiceRegistry()).getConnectors();
                for (int i = 0; i < tcs.length; ++i) {
                    if (tcs[i].getParams().containsKey("socket-binding")) {
                        connectorsSocketBindings.add(tcs[i].getParams().get("socket-binding").toString());
                    }
                    if (!tcs[i].getParams().containsKey("ssl-context")) continue;
                    sslContextNames.add(tcs[i].getParams().get("ssl-context").toString());
                }
            }
            ExternalPooledConnectionFactoryService.installService(serviceTarget, configuration, pcfName, tcs, discoveryGroupConfiguration, connectorsSocketBindings, sslContextNames, null, string, adapterParams, bindInfo, Collections.emptyList(), txSupport, this.minPoolSize, this.maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT));
        } else {
            serverName = JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties);
            PooledConnectionFactoryService.installService(serviceTarget, pcfName, serverName, connectors, discoveryGroupName, string, adapterParams, bindInfo, txSupport, this.minPoolSize, this.maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, true);
        }
        ServiceName referenceFactoryServiceName = ConnectionFactoryReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
        serviceBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, injector);
        String managementName = JMSConnectionFactoryDefinitionInjectionSource.managementName(context, name);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        PathElement pcfPath = PathElement.pathElement((String)"pooled-connection-factory", (String)managementName);
        if (external) {
            deploymentResourceSupport.getDeploymentSubsystemModel("messaging-activemq");
            registration = PathAddress.pathAddress((PathElement[])new PathElement[]{pcfPath});
        } else {
            PathElement serverElement = PathElement.pathElement((String)"server", (String)serverName);
            deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
            registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, pcfPath});
        }
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        if (external) {
            PooledConnectionFactoryConfigurationRuntimeHandler.EXTERNAL_INSTANCE.registerResource(serverName, managementName, model);
        } else {
            PooledConnectionFactoryConfigurationRuntimeHandler.INSTANCE.registerResource(serverName, managementName, model);
        }
    }

    private List<String> getConnectors(Map<String, String> props) {
        String connector;
        ArrayList<String> connectors = new ArrayList<String>();
        if (props.containsKey("connectors")) {
            String connectorsStr = (String)this.properties.remove("connectors");
            for (String s : connectorsStr.split(",")) {
                String connector2 = s.trim();
                if (connector2.isEmpty()) continue;
                connectors.add(connector2);
            }
        }
        if (props.containsKey("connector") && !(connector = ((String)this.properties.remove("connector")).trim()).isEmpty()) {
            connectors.add(connector);
        }
        return connectors;
    }

    void clearUnknownProperties(Map<String, String> props) {
        Map<String, ConnectionFactoryAttribute> attributesMap = PooledConnectionFactoryDefinition.getAttributesMap();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String value = entry.getKey();
            if (value == null || "".equals(value)) {
                it.remove();
                continue;
            }
            if (attributesMap.containsKey(entry.getKey())) continue;
            MessagingLogger.ROOT_LOGGER.unknownPooledConnectionFactoryAttribute(entry.getKey());
            it.remove();
        }
    }

    private static String uniqueName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        return uniqueName.append(context.getApplicationName()).append("_").append(JMSConnectionFactoryDefinitionInjectionSource.managementName(context, jndiName)).toString();
    }

    private static String managementName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(context.getModuleName()).append("_");
        if (context.getComponentName() != null) {
            uniqueName.append(context.getComponentName()).append("_");
        }
        return uniqueName.append(jndiName.replace(':', '_')).toString();
    }

    private List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model) {
        Map<String, ConnectionFactoryAttribute> attributes = PooledConnectionFactoryDefinition.getAttributesMap();
        ArrayList<PooledConnectionFactoryConfigProperties> props = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (Property property : model.asPropertyList()) {
            ConnectionFactoryAttribute attribute = attributes.get(property.getName());
            if (attribute.getPropertyName() == null) continue;
            props.add(new PooledConnectionFactoryConfigProperties(attribute.getPropertyName(), property.getValue().asString(), attribute.getClassType(), attribute.getConfigType()));
        }
        return props;
    }

    static boolean targetsPooledConnectionFactory(String server, String resourceAdapter, ServiceRegistry serviceRegistry) {
        if (resourceAdapter == null || resourceAdapter.isEmpty()) {
            return true;
        }
        ServiceName activeMQServiceName = MessagingServices.getActiveMQServiceName(server);
        ServiceName pcfName = JMSServices.getPooledConnectionFactoryBaseServiceName(activeMQServiceName).append(new String[]{resourceAdapter});
        return serviceRegistry.getServiceNames().contains(pcfName);
    }

    static boolean targetsExternalPooledConnectionFactory(String resourceAdapter, ServiceRegistry serviceRegistry) {
        if (resourceAdapter == null || resourceAdapter.isEmpty()) {
            return false;
        }
        ServiceName pcfName = JMSServices.getPooledConnectionFactoryBaseServiceName(MessagingServices.getActiveMQServiceName()).append(new String[]{resourceAdapter});
        return serviceRegistry.getServiceNames().contains(pcfName);
    }

    private static ExternalPooledConnectionFactoryService getExternalPooledConnectionFactory(String resourceAdapter, ServiceRegistry serviceRegistry) {
        ServiceName pcfName = JMSServices.getPooledConnectionFactoryBaseServiceName(MessagingServices.getActiveMQServiceName()).append(new String[]{resourceAdapter});
        return (ExternalPooledConnectionFactoryService)serviceRegistry.getService(pcfName).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDefaulResourceAdapter(DeploymentUnit deploymentUnit) {
        EEModuleDescription eeDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        if (eeDescription != null) {
            String defaultJndiName = eeDescription.getDefaultResourceJndiNames().getJmsConnectionFactory();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)defaultJndiName);
            ServiceController binder = deploymentUnit.getServiceRegistry().getService(bindInfo.getBinderServiceName());
            if (binder != null) {
                ManagedReference ref;
                Object ra;
                Object pcf = binder.getService().getValue();
                ServiceController.State currentState = binder.getState();
                final CountDownLatch latch = new CountDownLatch(1);
                if (currentState != ServiceController.State.UP) {
                    LifecycleListener lifecycleListener = new LifecycleListener(){

                        public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                            latch.countDown();
                        }
                    };
                    try {
                        binder.addListener(lifecycleListener);
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        String string = null;
                        return string;
                    }
                    finally {
                        binder.removeListener(lifecycleListener);
                    }
                }
                if (currentState != ServiceController.State.UP) {
                    return null;
                }
                if (pcf != null && pcf instanceof ContextListAndJndiViewManagedReferenceFactory && (ra = (ref = ((ContextListAndJndiViewManagedReferenceFactory)pcf).getReference()).getInstance()) instanceof ActiveMQRAConnectionFactoryImpl) {
                    bindInfo = ContextNames.bindInfoFor((String)((ActiveMQRAConnectionFactoryImpl)ra).getReference().getClassName());
                    binder = deploymentUnit.getServiceRegistry().getService(bindInfo.getBinderServiceName());
                    if (binder != null) {
                        pcf = binder.getService().getValue();
                    }
                }
                if (pcf != null && pcf instanceof ConnectionFactoryReferenceFactoryService) {
                    return ((ConnectionFactoryReferenceFactoryService)pcf).getName();
                }
            }
        }
        return null;
    }

    static String getActiveMQServerName(Map<String, String> properties) {
        return properties.getOrDefault("server", "default");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JMSConnectionFactoryDefinitionInjectionSource that = (JMSConnectionFactoryDefinitionInjectionSource)((Object)o);
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.minPoolSize != that.minPoolSize) {
            return false;
        }
        if (this.transactional != that.transactional) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.interfaceName != null ? !this.interfaceName.equals(that.interfaceName) : that.interfaceName != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.resourceAdapter != null ? !this.resourceAdapter.equals(that.resourceAdapter) : that.resourceAdapter != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.interfaceName != null ? this.interfaceName.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.resourceAdapter != null ? this.resourceAdapter.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.transactional ? 1 : 0);
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + this.minPoolSize;
        return result;
    }
}

