/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.wildfly.extension.messaging.activemq.AddressSettingDefinition;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.ha.ScaleDownAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;

public class MessagingTransformerRegistration
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "messaging-activemq";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        MessagingTransformerRegistration.registerTransformers_WF_36(builder.createBuilder(MessagingExtension.VERSION_17_0_0, MessagingExtension.VERSION_16_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_29(builder.createBuilder(MessagingExtension.VERSION_16_0_0, MessagingExtension.VERSION_15_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_28(builder.createBuilder(MessagingExtension.VERSION_15_0_0, MessagingExtension.VERSION_14_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_27(builder.createBuilder(MessagingExtension.VERSION_14_0_0, MessagingExtension.VERSION_13_1_0));
        MessagingTransformerRegistration.registerTransformers_WF_26_1(builder.createBuilder(MessagingExtension.VERSION_13_1_0, MessagingExtension.VERSION_13_0_0));
        builder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{MessagingExtension.VERSION_13_0_0, MessagingExtension.VERSION_13_1_0, MessagingExtension.VERSION_14_0_0, MessagingExtension.VERSION_15_0_0, MessagingExtension.VERSION_16_0_0, MessagingExtension.VERSION_17_0_0}});
    }

    private static void registerTransformers_WF_36(ResourceTransformationDescriptionBuilder subsystem) {
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(subsystem.addChildResource(MessagingExtension.SERVER_PATH).addChildResource(MessagingExtension.LIVE_ONLY_PATH), ScaleDownAttributes.SCALE_DOWN_COMMIT_INTERVAL);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(subsystem.addChildResource(MessagingExtension.SERVER_PATH).addChildResource(MessagingExtension.REPLICATION_SECONDARY_PATH), ScaleDownAttributes.SCALE_DOWN_COMMIT_INTERVAL);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(subsystem.addChildResource(MessagingExtension.SERVER_PATH).addChildResource(MessagingExtension.SHARED_STORE_SECONDARY_PATH), ScaleDownAttributes.SCALE_DOWN_COMMIT_INTERVAL);
    }

    private static void registerTransformers_WF_29(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder addressSettings = subsystem.addChildResource(MessagingExtension.SERVER_PATH).addChildResource(MessagingExtension.ADDRESS_SETTING_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(addressSettings, new AttributeDefinition[]{AddressSettingDefinition.MAX_READ_PAGE_BYTES});
    }

    private static void registerTransformers_WF_28(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        ((AttributeTransformationDescriptionBuilder)server.addChildResource(PathElement.pathElement((String)"remote-acceptor")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT});
        ((AttributeTransformationDescriptionBuilder)server.addChildResource(PathElement.pathElement((String)"http-acceptor")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT});
        ((AttributeTransformationDescriptionBuilder)server.addChildResource(PathElement.pathElement((String)"remote-connector")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT});
        ((AttributeTransformationDescriptionBuilder)server.addChildResource(PathElement.pathElement((String)"http-connector")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{CommonAttributes.SSL_CONTEXT});
    }

    private static void registerTransformers_WF_27(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder externaljmsqueue = subsystem.addChildResource(MessagingExtension.EXTERNAL_JMS_QUEUE_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(externaljmsqueue, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX);
        ResourceTransformationDescriptionBuilder externaljmstopic = subsystem.addChildResource(MessagingExtension.EXTERNAL_JMS_TOPIC_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(externaljmstopic, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX);
        ResourceTransformationDescriptionBuilder externalConnectionFactory = subsystem.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.renameAttribute(externalConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST);
        MessagingTransformerRegistration.renameAttribute(externalConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST);
        ResourceTransformationDescriptionBuilder pooledExternalConnectionFactory = subsystem.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.renameAttribute(pooledExternalConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST);
        MessagingTransformerRegistration.renameAttribute(pooledExternalConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST);
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        ResourceTransformationDescriptionBuilder bridge = server.addChildResource(MessagingExtension.BRIDGE_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(bridge, new AttributeDefinition[]{BridgeDefinition.ROUTING_TYPE});
        ResourceTransformationDescriptionBuilder connectionFactory = server.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.renameAttribute(connectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST);
        MessagingTransformerRegistration.renameAttribute(connectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST);
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = server.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.renameAttribute(pooledConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST);
        MessagingTransformerRegistration.renameAttribute(pooledConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, (AttributeDefinition)ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST);
        server.addChildRedirection(MessagingExtension.REPLICATION_PRIMARY_PATH, MessagingExtension.REPLICATION_MASTER_PATH);
        server.addChildRedirection(MessagingExtension.REPLICATION_SECONDARY_PATH, MessagingExtension.REPLICATION_SLAVE_PATH);
        server.addChildRedirection(MessagingExtension.SHARED_STORE_PRIMARY_PATH, MessagingExtension.SHARED_STORE_MASTER_PATH);
        server.addChildRedirection(MessagingExtension.SHARED_STORE_SECONDARY_PATH, MessagingExtension.SHARED_STORE_SLAVE_PATH);
        ResourceTransformationDescriptionBuilder colocatedSharedStore = server.addChildResource(MessagingExtension.SHARED_STORE_COLOCATED_PATH);
        colocatedSharedStore.addChildRedirection(MessagingExtension.CONFIGURATION_PRIMARY_PATH, MessagingExtension.CONFIGURATION_MASTER_PATH);
        colocatedSharedStore.addChildRedirection(MessagingExtension.CONFIGURATION_SECONDARY_PATH, MessagingExtension.CONFIGURATION_SLAVE_PATH);
        ResourceTransformationDescriptionBuilder colocatedReplication = server.addChildResource(MessagingExtension.REPLICATION_COLOCATED_PATH);
        colocatedReplication.addChildRedirection(MessagingExtension.CONFIGURATION_PRIMARY_PATH, MessagingExtension.CONFIGURATION_MASTER_PATH);
        colocatedReplication.addChildRedirection(MessagingExtension.CONFIGURATION_SECONDARY_PATH, MessagingExtension.CONFIGURATION_SLAVE_PATH);
        ResourceTransformationDescriptionBuilder addressSetting = server.addChildResource(MessagingExtension.ADDRESS_SETTING_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.AUTO_DELETE_CREATED_QUEUES});
    }

    private static void registerTransformers_WF_26_1(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.ADDRESS_QUEUE_SCAN_PERIOD});
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, attrs)).addRejectCheck(RejectAttributeChecker.DEFINED, attrs);
    }

    private static void renameAttribute(ResourceTransformationDescriptionBuilder resourceRegistry, AttributeDefinition attribute, AttributeDefinition newAttribute) {
        ((AttributeTransformationDescriptionBuilder)resourceRegistry.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{newAttribute})).addRename(newAttribute, attribute.getName());
    }
}

