/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Set;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.SecurityRoleDefinition;
import org.wildfly.extension.messaging.activemq.SecurityRoleRemove;

class SecurityRoleAdd
extends AbstractAddStepHandler {
    static final SecurityRoleAdd INSTANCE = new SecurityRoleAdd((AttributeDefinition[])SecurityRoleDefinition.ATTRIBUTES);

    private SecurityRoleAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isNormalServer()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            ActiveMQServer server = SecurityRoleAdd.getServer(context, operation);
            String match = address.getElement(address.size() - 2).getValue();
            String roleName = address.getLastElement().getValue();
            if (server != null) {
                Role role = SecurityRoleDefinition.transform(context, roleName, model);
                Set roles = (Set)server.getSecurityRepository().getMatch(match);
                roles.add(role);
                server.getSecurityRepository().addMatch(match, (Object)roles);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ActiveMQServer server = SecurityRoleAdd.getServer(context, operation);
        String match = address.getElement(address.size() - 2).getValue();
        String roleName = address.getLastElement().getValue();
        SecurityRoleRemove.removeRole(server, match, roleName);
    }

    static ActiveMQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller != null) {
            return (ActiveMQServer)ActiveMQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

