/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.OperationValidator;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BroadcastGroupDefinition
extends ModelOnlyResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"broadcast-group");
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"connectors", (ModelType)ModelType.STRING).setAllowNull(true)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setXmlName("connector-ref")).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.WrappedListAttributeMarshaller(null))).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition BROADCAST_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"broadcast-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultBroadcastPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.JGROUPS_STACK, CommonAttributes.JGROUPS_CHANNEL, CommonAttributes.SOCKET_BINDING, CommonAttributes.LOCAL_BIND_ADDRESS, CommonAttributes.LOCAL_BIND_PORT, CommonAttributes.GROUP_ADDRESS, CommonAttributes.GROUP_PORT, BROADCAST_PERIOD, CONNECTOR_REFS};
    private static final OperationValidator VALIDATOR = new OperationValidator.AttributeDefinitionOperationValidator(ATTRIBUTES);
    static final BroadcastGroupDefinition INSTANCE = new BroadcastGroupDefinition();

    public BroadcastGroupDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("broadcast-group"), new ModelOnlyAddStepHandler(ATTRIBUTES){

            protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
                model.setEmptyObject();
                VALIDATOR.validateAndSet(operation, model);
            }

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                final ModelNode connectorRefs = resource.getModel().get(CONNECTOR_REFS.getName());
                if (connectorRefs.isDefined()) {
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            BroadcastGroupDefinition.validateConnectors(context, operation, connectorRefs);
                        }
                    }, OperationContext.Stage.MODEL);
                }
            }
        }, ATTRIBUTES);
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    static void validateConnectors(OperationContext context, ModelNode operation, ModelNode connectorRefs) throws OperationFailedException {
        Set<String> availableConnectors = BroadcastGroupDefinition.getAvailableConnectors(context, operation);
        List operationAddress = operation.get("address").asList();
        String broadCastGroup = ((ModelNode)operationAddress.get(operationAddress.size() - 1)).get("broadcast-group").asString();
        for (ModelNode connectorRef : connectorRefs.asList()) {
            String connectorName = connectorRef.asString();
            if (availableConnectors.contains(connectorName)) continue;
            throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(broadCastGroup, connectorName, availableConnectors);
        }
    }

    private static Set<String> getAvailableConnectors(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress hornetqServer = context.getCurrentAddress().getParent();
        Resource hornetQServerResource = context.readResourceFromRoot(hornetqServer);
        HashSet<String> availableConnectors = new HashSet<String>();
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("http-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("in-vm-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("remote-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("connector"));
        return availableConnectors;
    }
}

