/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.server.JournalType;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.Validators;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface CommonAttributes {
    public static final String DISCOVERY_GROUP_NAME = "discovery-group-name";
    public static final String ENTRIES = "entries";
    public static final SensitivityClassification MESSAGING_MANAGEMENT = new SensitivityClassification("messaging", "messaging-management", false, false, true);
    public static final SensitiveTargetAccessConstraintDefinition MESSAGING_MANAGEMENT_DEF = new SensitiveTargetAccessConstraintDefinition(MESSAGING_MANAGEMENT);
    public static final SensitivityClassification MESSAGING_SECURITY = new SensitivityClassification("messaging", "messaging-security", false, false, true);
    public static final SensitiveTargetAccessConstraintDefinition MESSAGING_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(MESSAGING_SECURITY);
    public static final SimpleAttributeDefinition ALLOW_FAILBACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"allow-failback", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultAllowAutoFailback()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ASYNC_CONNECTION_EXECUTION_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"async-connection-execution-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition BACKUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"backup", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultBackup()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition CALL_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"call-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(30000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CALL_FAILOVER_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"call-failover-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(-1L))).setAllowNull(true)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
    public static final SimpleAttributeDefinition CHECK_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD))).setAllowNull(true)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"client-id", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CHECK_FOR_LIVE_SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"check-for-live-server", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultCheckForLiveServer()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CLUSTERED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"clustered", (ModelType)ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setDeprecated(MessagingExtension.VERSION_1_2_0)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CLUSTER_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-password", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterPassword()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition CLUSTER_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-user", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultClusterUser()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition BRIDGE_CONFIRMATION_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"confirmation-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(0x100000))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-ttl", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(HornetQClient.DEFAULT_CONNECTION_TTL))).setAllowNull(true)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL_OVERRIDE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-ttl-override", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultConnectionTtlOverride()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CREATE_BINDINGS_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-bindings-dir", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultCreateBindingsDir()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CREATE_JOURNAL_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-journal-dir", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultCreateJournalDir()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DEAD_LETTER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"dead-letter-address", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final PrimitiveListAttributeDefinition DESTINATION_ENTRIES = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"entries", (ModelType)ModelType.STRING).setAllowNull(false)).setListValidator((ParameterValidator)Validators.noDuplicateElements((ParameterValidator)new StringLengthValidator(1, false, true)))).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.JndiEntriesAttributeMarshaller(true))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DURABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"durable", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition FACTORY_CLASS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"factory-class", (ModelType)ModelType.STRING).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition EXPIRY_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"expiry-address", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition FAILBACK_DELAY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failback-delay", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultFailbackDelay()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition FAILOVER_ON_SERVER_SHUTDOWN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failover-on-server-shutdown", (ModelType)ModelType.BOOLEAN).setAllowNull(true)).setDeprecated(MessagingExtension.VERSION_1_2_0)).build();
    public static final SimpleAttributeDefinition FAILOVER_ON_SHUTDOWN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failover-on-shutdown", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"filter", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    @Deprecated
    public static final SimpleAttributeDefinition GROUP_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"group-address", (ModelType)ModelType.STRING).setAllowNull(true)).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"})).setDeprecated(MessagingExtension.VERSION_1_2_0)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    @Deprecated
    public static final SimpleAttributeDefinition GROUP_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"group-port", (ModelType)ModelType.INT).setAllowNull(true)).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"})).setDeprecated(MessagingExtension.VERSION_1_2_0)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition HA = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ha", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ID_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"id-cache-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultIdCacheSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JMX_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jmx-domain", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultJmxDomain()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MESSAGING_MANAGEMENT_DEF)).build();
    public static final SimpleAttributeDefinition JMX_MANAGEMENT_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jmx-management-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MESSAGING_MANAGEMENT_DEF)).build();
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-buffer-size", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-buffer-timeout", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_MIN_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-compact-min-files", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultJournalCompactMinFiles()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_PERCENTAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-compact-percentage", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultJournalCompactPercentage()))).setMeasurementUnit(MeasurementUnit.PERCENTAGE)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_FILE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-file-size", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultJournalFileSize()))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MAX_IO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-max-io", (ModelType)ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MIN_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-min-files", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultJournalMinFiles()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_SYNC_NON_TRANSACTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-sync-non-transactional", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultJournalSyncNonTransactional()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_SYNC_TRANSACTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-sync-transactional", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultJournalSyncTransactional()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-type", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(ConfigurationImpl.DEFAULT_JOURNAL_TYPE.toString()))).setAllowNull(true)).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(JournalType.class, true, true))).setRestartAllServices()).build();
    public static final AttributeDefinition LIVE_CONNECTOR_REF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"live-connector-ref", (ModelType)ModelType.STRING).setAllowNull(true)).setDeprecated(MessagingExtension.VERSION_1_2_0)).setRestartAllServices()).setAttributeMarshaller(AttributeMarshallers.NOOP_MARSHALLER)).build();
    @Deprecated
    public static final SimpleAttributeDefinition LOCAL_BIND_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"local-bind-address", (ModelType)ModelType.STRING).setAllowNull(true)).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"})).setDeprecated(MessagingExtension.VERSION_1_2_0)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    @Deprecated
    public static final SimpleAttributeDefinition LOCAL_BIND_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"local-bind-port", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setAllowNull(true)).setAlternatives(new String[]{"socket-binding", "jgroups-stack", "jgroups-channel"})).setDeprecated(MessagingExtension.VERSION_1_2_0)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition JGROUPS_STACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jgroups-stack", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setAlternatives(new String[]{"socket-binding", "group-address", "group-port", "local-bind-address", "local-bind-port"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JGROUPS_CHANNEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jgroups-channel", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setAlternatives(new String[]{"socket-binding", "group-address", "group-port", "local-bind-address", "local-bind-port"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition LOG_JOURNAL_WRITE_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-journal-write-rate", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultJournalLogWriteRate()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MANAGEMENT_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-address", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultManagementAddress().toString()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MESSAGING_MANAGEMENT_DEF)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_NOTIFICATION_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-notification-address", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultManagementNotificationAddress().toString()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MESSAGING_MANAGEMENT_DEF)).build();
    public static final AttributeDefinition MAX_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQClient.DEFAULT_MAX_RETRY_INTERVAL))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition MAX_SAVED_REPLICATED_JOURNAL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-saved-replicated-journal-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MEMORY_MEASURE_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"memory-measure-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMemoryMeasureInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MEMORY_WARNING_THRESHOLD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"memory-warning-threshold", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMemoryWarningThreshold()))).setMeasurementUnit(MeasurementUnit.PERCENTAGE)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"statistics-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).setDeprecated(ModelVersion.create((int)2))).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_MAX_DAY_HISTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-max-day-history", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory()))).setMeasurementUnit(MeasurementUnit.DAYS)).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_SAMPLE_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-sample-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMessageCounterSamplePeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_SCAN_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-expiry-scan-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMessageExpiryScanPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_THREAD_PRIORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-expiry-thread-priority", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMessageExpiryThreadPriority()))).setAllowNull(true)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, 10, true, true))).setRestartAllServices()).build();
    public static final AttributeDefinition MIN_LARGE_MESSAGE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-large-message-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(102400))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition BACKUP_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"backup-group-name", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition OVERRIDE_IN_VM_SECURITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"override-in-vm-security", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PAGE_MAX_CONCURRENT_IO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"page-max-concurrent-io", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultMaxConcurrentPageIo()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERF_BLAST_PAGES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"perf-blast-pages", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultJournalPerfBlastPages()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-delivery-count-before-delivery", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERSISTENCE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persistence-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultPersistenceEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERSIST_ID_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-id-cache", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultPersistIdCache()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    @Deprecated
    public static final PrimitiveListAttributeDefinition REMOTING_INTERCEPTORS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("remoting-interceptors", ModelType.STRING).setDeprecated(MessagingExtension.VERSION_1_2_0)).setAllowNull(true)).setAllowExpression(false)).setMinSize(1)).setMaxSize(Integer.MAX_VALUE)).setRestartAllServices()).setElementValidator((ParameterValidator)new StringLengthValidator(1, false, true))).setAttributeMarshaller(AttributeMarshallers.INTERCEPTOR_MARSHALLER)).build();
    public static final PrimitiveListAttributeDefinition REMOTING_INCOMING_INTERCEPTORS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("remoting-incoming-interceptors", ModelType.STRING).setAllowNull(true)).setAllowExpression(false)).setMinSize(1)).setMaxSize(Integer.MAX_VALUE)).setRestartAllServices()).setElementValidator((ParameterValidator)new StringLengthValidator(1, false, true))).setAttributeMarshaller(AttributeMarshallers.INTERCEPTOR_MARSHALLER)).build();
    public static final PrimitiveListAttributeDefinition REMOTING_OUTGOING_INTERCEPTORS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("remoting-outgoing-interceptors", ModelType.STRING).setAllowNull(true)).setAllowExpression(false)).setMinSize(1)).setMaxSize(Integer.MAX_VALUE)).setRestartAllServices()).setElementValidator((ParameterValidator)new StringLengthValidator(1, false, true))).setAttributeMarshaller(AttributeMarshallers.INTERCEPTOR_MARSHALLER)).build();
    public static final SimpleAttributeDefinition REPLICATION_CLUSTERNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"replication-clustername", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(2000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition RETRY_INTERVAL_MULTIPLIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.BIG_DECIMAL).setDefaultValue(new ModelNode(HornetQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RUN_SYNC_SPEED_TEST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"run-sync-speed-test", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultRunSyncSpeedTest()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(HornetQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-domain", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode("other"))).setAllowNull(true)).setAllowExpression(false)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF)).addAccessConstraint((AccessConstraintDefinition)MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultSecurityEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_INVALIDATION_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-invalidation-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultSecurityInvalidationInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SELECTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"selector", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setAttributeMarshaller(AttributeMarshallers.SELECTOR_MARSHALLER)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SERVER_DUMP_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"server-dump-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultServerDumpInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SHARED_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"shared-store", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultSharedStore()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding", (ModelType)ModelType.STRING).setAllowNull(true)).setAlternatives(new String[]{GROUP_ADDRESS.getName(), GROUP_PORT.getName(), LOCAL_BIND_ADDRESS.getName(), LOCAL_BIND_PORT.getName(), JGROUPS_STACK.getName(), JGROUPS_CHANNEL.getName()})).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final AttributeDefinition THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(HornetQDefaultConfiguration.getDefaultThreadPoolMaxSize()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultTransactionTimeout()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT_SCAN_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-timeout-scan-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition TRANSFORMER_CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transformer-class-name", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition WILD_CARD_ROUTING_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"wild-card-routing-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.isDefaultWildcardRoutingEnabled()))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final String ACCEPTOR = "acceptor";
    public static final String ACCEPTORS = "acceptors";
    public static final String ADDRESS = "address";
    public static final String ADDRESS_SETTING = "address-setting";
    public static final String ADDRESS_SETTINGS = "address-settings";
    public static final String BINDINGS_DIRECTORY = "bindings-directory";
    public static final String BRIDGE = "bridge";
    public static final String BRIDGES = "bridges";
    public static final String BROADCAST_GROUP = "broadcast-group";
    public static final String BROADCAST_GROUPS = "broadcast-groups";
    public static final String CLASS_NAME = "class-name";
    public static final String CLUSTER_CONNECTION = "cluster-connection";
    public static final String CLUSTER_CONNECTIONS = "cluster-connections";
    public static final String CONNECTION_FACTORY = "connection-factory";
    public static final String CONNECTOR = "connector";
    public static final String CONNECTORS = "connectors";
    public static final String CONNECTOR_NAME = "connector-name";
    public static final String CONNECTOR_REF_STRING = "connector-ref";
    public static final String CONNECTOR_SERVICE = "connector-service";
    public static final String CONNECTOR_SERVICES = "connector-services";
    public static final String CORE_QUEUE = "core-queue";
    public static final String CORE_QUEUES = "core-queues";
    public static final String DEFAULT = "default";
    public static final String DESTINATION = "destination";
    public static final String DISCOVERY_GROUP = "discovery-group";
    public static final String DISCOVERY_GROUPS = "discovery-groups";
    public static final String DISCOVERY_GROUP_REF = "discovery-group-ref";
    public static final String DIVERT = "divert";
    public static final String DIVERTS = "diverts";
    public static final String ENTRY = "entry";
    public static final String FILE_DEPLOYMENT_ENABLED = "file-deployment-enabled";
    public static final String GROUPING_HANDLER = "grouping-handler";
    public static final String HTTP_ACCEPTOR = "http-acceptor";
    public static final String HTTP_CONNECTOR = "http-connector";
    public static final String HTTP_LISTENER = "http-listener";
    public static final String IN_VM_ACCEPTOR = "in-vm-acceptor";
    public static final String IN_VM_CONNECTOR = "in-vm-connector";
    public static final String JMS_BRIDGE = "jms-bridge";
    public static final String JMS_CONNECTION_FACTORIES = "jms-connection-factories";
    public static final String JMS_DESTINATIONS = "jms-destinations";
    public static final String JMS_QUEUE = "jms-queue";
    public static final String JMS_TOPIC = "jms-topic";
    public static final String JOURNAL_DIRECTORY = "journal-directory";
    public static final String KEY = "key";
    public static final String INBOUND_CONFIG = "inbound-config";
    public static final String LARGE_MESSAGES_DIRECTORY = "large-messages-directory";
    public static final String LOCAL = "local";
    public static final String MATCH = "match";
    public static final String MODE = "mode";
    public static final String NAME = "name";
    public static final String NETTY_ACCEPTOR = "netty-acceptor";
    public static final String NETTY_CONNECTOR = "netty-connector";
    public static final String PAGING_DIRECTORY = "paging-directory";
    public static final String PARAM = "param";
    public static final String PERMISSION_ELEMENT_NAME = "permission";
    public static final String POOLED_CONNECTION_FACTORY = "pooled-connection-factory";
    public static final String QUEUE = "queue";
    public static final String QUEUE_NAME = "queue-name";
    public static final String REMOTE_ACCEPTOR = "remote-acceptor";
    public static final String REMOTE_CONNECTOR = "remote-connector";
    public static final String ROLE = "role";
    public static final String ROLES_ATTR_NAME = "roles";
    public static final String SECURITY_ROLE = "security-role";
    public static final String SECURITY_SETTING = "security-setting";
    public static final String SECURITY_SETTINGS = "security-settings";
    public static final String HORNETQ_SERVER = "hornetq-server";
    public static final String STATIC_CONNECTORS = "static-connectors";
    public static final String STRING = "string";
    public static final String SUBSYSTEM = "subsystem";
    public static final String TYPE_ATTR_NAME = "type";
    public static final AttributeDefinition[] SIMPLE_ROOT_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{CLUSTERED, PERSISTENCE_ENABLED, SCHEDULED_THREAD_POOL_MAX_SIZE, THREAD_POOL_MAX_SIZE, SECURITY_DOMAIN, SECURITY_ENABLED, SECURITY_INVALIDATION_INTERVAL, OVERRIDE_IN_VM_SECURITY, WILD_CARD_ROUTING_ENABLED, MANAGEMENT_ADDRESS, MANAGEMENT_NOTIFICATION_ADDRESS, CLUSTER_USER, CLUSTER_PASSWORD, JMX_MANAGEMENT_ENABLED, JMX_DOMAIN, STATISTICS_ENABLED, MESSAGE_COUNTER_ENABLED, MESSAGE_COUNTER_SAMPLE_PERIOD, MESSAGE_COUNTER_MAX_DAY_HISTORY, CONNECTION_TTL_OVERRIDE, ASYNC_CONNECTION_EXECUTION_ENABLED, TRANSACTION_TIMEOUT, TRANSACTION_TIMEOUT_SCAN_PERIOD, MESSAGE_EXPIRY_SCAN_PERIOD, MESSAGE_EXPIRY_THREAD_PRIORITY, ID_CACHE_SIZE, PERSIST_ID_CACHE, REMOTING_INTERCEPTORS, REMOTING_INCOMING_INTERCEPTORS, REMOTING_OUTGOING_INTERCEPTORS, BACKUP, ALLOW_FAILBACK, FAILBACK_DELAY, FAILOVER_ON_SHUTDOWN, SHARED_STORE, PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY, PAGE_MAX_CONCURRENT_IO, CREATE_BINDINGS_DIR, CREATE_JOURNAL_DIR, JOURNAL_TYPE, JOURNAL_BUFFER_TIMEOUT, JOURNAL_BUFFER_SIZE, JOURNAL_SYNC_TRANSACTIONAL, JOURNAL_SYNC_NON_TRANSACTIONAL, LOG_JOURNAL_WRITE_RATE, JOURNAL_FILE_SIZE, JOURNAL_MIN_FILES, JOURNAL_COMPACT_PERCENTAGE, JOURNAL_COMPACT_MIN_FILES, JOURNAL_MAX_IO, MAX_SAVED_REPLICATED_JOURNAL_SIZE, PERF_BLAST_PAGES, RUN_SYNC_SPEED_TEST, SERVER_DUMP_INTERVAL, MEMORY_WARNING_THRESHOLD, MEMORY_MEASURE_INTERVAL, CHECK_FOR_LIVE_SERVER, BACKUP_GROUP_NAME, REPLICATION_CLUSTERNAME};
}

