/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface InfiniteOrPositiveValidators {
    public static final ModelTypeValidator LONG_INSTANCE = new ModelTypeValidator(ModelType.LONG){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            long val = value.asLong();
            if (val != -1L && (val <= 0L || val >= Long.MAX_VALUE)) {
                throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.illegalValue(value, parameterName)));
            }
        }
    };
    public static final ModelTypeValidator INT_INSTANCE = new ModelTypeValidator(ModelType.INT){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            int val = value.asInt();
            if (val != -1 && (val <= 0 || val >= Integer.MAX_VALUE)) {
                throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.illegalValue(value, parameterName)));
            }
        }
    };
}

