package org.jboss.as.messaging.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.messaging.Element;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelType;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-10-23T22:28:06-0500")
public class MessagingLogger_$logger extends DelegatingBasicLogger implements MessagingLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MessagingLogger_$logger.class.getName();
    public MessagingLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void deprecatedXMLElement(final String name) {
        super.log.logf(FQCN, WARN, null, deprecatedXMLElement1$str(), name);
    }
    private static final String deprecatedXMLElement1 = "WFLYMSG0009: Element %s is deprecated and will not be taken into account";
    protected String deprecatedXMLElement1$str() {
        return deprecatedXMLElement1;
    }
    @Override
    public final void deprecatedXMLAttribute(final String name) {
        super.log.logf(FQCN, WARN, null, deprecatedXMLAttribute$str(), name);
    }
    private static final String deprecatedXMLAttribute = "WFLYMSG0010: Attribute %s is deprecated and will not be taken into account";
    protected String deprecatedXMLAttribute$str() {
        return deprecatedXMLAttribute;
    }
    @Override
    public final void deprecatedAttribute(final String name, final PathAddress address) {
        super.log.logf(FQCN, WARN, null, deprecatedAttribute$str(), name, address);
    }
    private static final String deprecatedAttribute = "WFLYMSG0013: Attribute %s of the resource at %s is deprecated and setting its value will not be taken into account";
    protected String deprecatedAttribute$str() {
        return deprecatedAttribute;
    }
    private static final String canNotChangeClusteredAttribute = "WFLYMSG0014: Can not change the clustered attribute to false: The hornetq-server resource at %s has cluster-connection children resources and will remain clustered.";
    protected String canNotChangeClusteredAttribute$str() {
        return canNotChangeClusteredAttribute;
    }
    @Override
    public final String canNotChangeClusteredAttribute(final PathAddress address) {
        return String.format(getLoggingLocale(), canNotChangeClusteredAttribute$str(), address);
    }
    @Override
    public final void deprecatedXMLElement(final String name, final String replacement) {
        super.log.logf(FQCN, WARN, null, deprecatedXMLElement2$str(), name, replacement);
    }
    private static final String deprecatedXMLElement2 = "WFLYMSG0017: Element %s is deprecated and %s will be used in its place";
    protected String deprecatedXMLElement2$str() {
        return deprecatedXMLElement2;
    }
    private static final String altAttributeAlreadyDefined = "WFLYMSG0019: Alternative attribute of (%s) is already defined.";
    protected String altAttributeAlreadyDefined$str() {
        return altAttributeAlreadyDefined;
    }
    @Override
    public final String altAttributeAlreadyDefined(final String name) {
        return String.format(getLoggingLocale(), altAttributeAlreadyDefined$str(), name);
    }
    private static final String attributeDefinitionsMustMatch = "WFLYMSG0020: All attribute definitions must have the same xml name -- found %s but already had %s";
    protected String attributeDefinitionsMustMatch$str() {
        return attributeDefinitionsMustMatch;
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsMustMatch(final String nameFound, final String nameRequired) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attributeDefinitionsMustMatch$str(), nameFound, nameRequired));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeDefinitionsNotUnique = "WFLYMSG0021: All attribute definitions must have unique names -- already found %s";
    protected String attributeDefinitionsNotUnique$str() {
        return attributeDefinitionsNotUnique;
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsNotUnique(final String nameFound) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attributeDefinitionsNotUnique$str(), nameFound));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotIncludeOperationParameters = "WFLYMSG0023: Operation cannot include both parameter %s and parameter %s";
    protected String cannotIncludeOperationParameters$str() {
        return cannotIncludeOperationParameters;
    }
    @Override
    public final String cannotIncludeOperationParameters(final String paramName1, final String paramName2) {
        return String.format(getLoggingLocale(), cannotIncludeOperationParameters$str(), paramName1, paramName2);
    }
    private static final String ignoringUnhandledElement = "WFLYMSG0034: Ignoring unhandled element: %s, at: %s";
    protected String ignoringUnhandledElement$str() {
        return ignoringUnhandledElement;
    }
    @Override
    public final XMLStreamException ignoringUnhandledElement(final Element element, final String location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), ignoringUnhandledElement$str(), element, location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalElement = "WFLYMSG0035: Illegal element %s: cannot be used when %s is used";
    protected String illegalElement$str() {
        return illegalElement;
    }
    @Override
    public final String illegalElement(final String illegalElement, final String element) {
        return String.format(getLoggingLocale(), illegalElement$str(), illegalElement, element);
    }
    private static final String illegalValue2 = "WFLYMSG0036: Illegal value %s for element %s";
    protected String illegalValue2$str() {
        return illegalValue2;
    }
    @Override
    public final String illegalValue(final Object value, final String element) {
        return String.format(getLoggingLocale(), illegalValue2$str(), value, element);
    }
    private static final String illegalValue3 = "WFLYMSG0036: Illegal value %s for element %s as it could not be converted to required type %s";
    protected String illegalValue3$str() {
        return illegalValue3;
    }
    @Override
    public final String illegalValue(final Object value, final String element, final ModelType expectedType) {
        return String.format(getLoggingLocale(), illegalValue3$str(), value, element, expectedType);
    }
    private static final String invalid = "WFLYMSG0038: %s is invalid";
    protected String invalid$str() {
        return invalid;
    }
    @Override
    public final String invalid(final Object obj) {
        return String.format(getLoggingLocale(), invalid$str(), obj);
    }
    private static final String invalidAttributeType = "WFLYMSG0039: Attribute %s has unexpected type %s";
    protected String invalidAttributeType$str() {
        return invalidAttributeType;
    }
    @Override
    public final IllegalStateException invalidAttributeType(final String name, final ModelType type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidAttributeType$str(), name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperationParameters = "WFLYMSG0040: Operation must include parameter %s or parameter %s";
    protected String invalidOperationParameters$str() {
        return invalidOperationParameters;
    }
    @Override
    public final String invalidOperationParameters(final String paramName1, final String paramName2) {
        return String.format(getLoggingLocale(), invalidOperationParameters$str(), paramName1, paramName2);
    }
    private static final String multipleChildrenFound = "WFLYMSG0044: Multiple %s children found; only one is allowed";
    protected String multipleChildrenFound$str() {
        return multipleChildrenFound;
    }
    @Override
    public final IllegalStateException multipleChildrenFound(final String element) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleChildrenFound$str(), element));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String required1 = "WFLYMSG0045: %s is required";
    protected String required1$str() {
        return required1;
    }
    @Override
    public final String required(final Object obj) {
        return String.format(getLoggingLocale(), required1$str(), obj);
    }
    private static final String required2 = "WFLYMSG0046: Either %s or %s is required";
    protected String required2$str() {
        return required2;
    }
    @Override
    public final String required(final Object obj1, final Object obj2) {
        return String.format(getLoggingLocale(), required2$str(), obj1, obj2);
    }
    private static final String unsupportedElement = "WFLYMSG0051: Implement support for element %s";
    protected String unsupportedElement$str() {
        return unsupportedElement;
    }
    @Override
    public final UnsupportedOperationException unsupportedElement(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedElement$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneRequired = "WFLYMSG0059: Only one of %s or %s is required";
    protected String onlyOneRequired$str() {
        return onlyOneRequired;
    }
    @Override
    public final String onlyOneRequired(final Object obj1, final Object obj2) {
        return String.format(getLoggingLocale(), onlyOneRequired$str(), obj1, obj2);
    }
    private static final String wrongConnectorRefInBroadCastGroup = "WFLYMSG0067: The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.";
    protected String wrongConnectorRefInBroadCastGroup$str() {
        return wrongConnectorRefInBroadCastGroup;
    }
    @Override
    public final OperationFailedException wrongConnectorRefInBroadCastGroup(final String bgName, final String connectorRef, final java.util.Collection<String> presentConnectors) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), wrongConnectorRefInBroadCastGroup$str(), bgName, connectorRef, presentConnectors));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefineAttributeWithoutAlternative = "WFLYMSG0069: Attribute (%s) can not been undefined as the resource does not define any alternative to this attribute.";
    protected String undefineAttributeWithoutAlternative$str() {
        return undefineAttributeWithoutAlternative;
    }
    @Override
    public final String undefineAttributeWithoutAlternative(final String name) {
        return String.format(getLoggingLocale(), undefineAttributeWithoutAlternative$str(), name);
    }
    private static final String inconsistentStatisticsSettings = "WFLYMSG0070: Attributes %s is an alias for attribute %s; both cannot be set with conflicting values.";
    protected String inconsistentStatisticsSettings$str() {
        return inconsistentStatisticsSettings;
    }
    @Override
    public final OperationFailedException inconsistentStatisticsSettings(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), inconsistentStatisticsSettings$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noMatchingExpiryAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, WARN, null, noMatchingExpiryAddress$str(), address, addressSettings);
    }
    private static final String noMatchingExpiryAddress = "WFLYMSG0071: There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!";
    protected String noMatchingExpiryAddress$str() {
        return noMatchingExpiryAddress;
    }
    @Override
    public final void noMatchingDeadLetterAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, WARN, null, noMatchingDeadLetterAddress$str(), address, addressSettings);
    }
    private static final String noMatchingDeadLetterAddress = "WFLYMSG0072: There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!";
    protected String noMatchingDeadLetterAddress$str() {
        return noMatchingDeadLetterAddress;
    }
    private static final String duplicateElements = "WFLYMSG0076: Parameter %s contains duplicate elements [%s]";
    protected String duplicateElements$str() {
        return duplicateElements;
    }
    @Override
    public final OperationFailedException duplicateElements(final String parameterName, final ModelNode elements) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), duplicateElements$str(), parameterName, elements));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String migrateOperationAllowedOnlyInAdminOnly = "WFLYMSG0079: The migrate operation can not be performed: the server must be in admin-only mode";
    protected String migrateOperationAllowedOnlyInAdminOnly$str() {
        return migrateOperationAllowedOnlyInAdminOnly;
    }
    @Override
    public final OperationFailedException migrateOperationAllowedOnlyInAdminOnly() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), migrateOperationAllowedOnlyInAdminOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotMigrateBroadcastGroupAttribute = "WFLYMSG0080: Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this broadcast-group.";
    protected String couldNotMigrateBroadcastGroupAttribute$str() {
        return couldNotMigrateBroadcastGroupAttribute;
    }
    @Override
    public final String couldNotMigrateBroadcastGroupAttribute(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateBroadcastGroupAttribute$str(), attribute, address);
    }
    private static final String migrationFailed = "WFLYMSG0081: Migration failed, see results for more details.";
    protected String migrationFailed$str() {
        return migrationFailed;
    }
    @Override
    public final String migrationFailed() {
        return String.format(getLoggingLocale(), migrationFailed$str());
    }
    private static final String couldNotMigrateInterceptors = "WFLYMSG0082: Classes providing the %s are discarded during the migration. To use them in the new messaging-activemq subsystem, you will have to extend the Artemis-based Interceptor.";
    protected String couldNotMigrateInterceptors$str() {
        return couldNotMigrateInterceptors;
    }
    @Override
    public final String couldNotMigrateInterceptors(final String legacyInterceptorsAttributeName) {
        return String.format(getLoggingLocale(), couldNotMigrateInterceptors$str(), legacyInterceptorsAttributeName);
    }
    private static final String couldNotMigrateHA = "WFLYMSG0083: Can not migrate the HA configuration of %s. Its shared-store and backup attributes holds expressions and it is not possible to determine unambiguously how to create the corresponding ha-policy for the messaging-activemq's server.";
    protected String couldNotMigrateHA$str() {
        return couldNotMigrateHA;
    }
    @Override
    public final String couldNotMigrateHA(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateHA$str(), address);
    }
    private static final String couldNotMigrateDiscoveryGroupAttribute = "WFLYMSG0084: Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this discovery-group.";
    protected String couldNotMigrateDiscoveryGroupAttribute$str() {
        return couldNotMigrateDiscoveryGroupAttribute;
    }
    @Override
    public final String couldNotMigrateDiscoveryGroupAttribute(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateDiscoveryGroupAttribute$str(), attribute, address);
    }
    private static final String couldNotCreateLegacyConnectionFactoryUsingInVMConnector = "WFLYMSG0085: Can not create a legacy-connection-factory based on connection-factory %s. It uses a HornetQ in-vm connector that is not compatible with Artemis in-vm connector ";
    protected String couldNotCreateLegacyConnectionFactoryUsingInVMConnector$str() {
        return couldNotCreateLegacyConnectionFactoryUsingInVMConnector;
    }
    @Override
    public final String couldNotCreateLegacyConnectionFactoryUsingInVMConnector(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotCreateLegacyConnectionFactoryUsingInVMConnector$str(), address);
    }
    private static final String couldNotMigrateResourceAttributeWithExpression = "WFLYMSG0086: Can not migrate attribute %s to resource %s. The attribute uses an expression that can be resolved differently depending on system properties. After migration, this attribute must be added back with an actual value instead of the expression.";
    protected String couldNotMigrateResourceAttributeWithExpression$str() {
        return couldNotMigrateResourceAttributeWithExpression;
    }
    @Override
    public final String couldNotMigrateResourceAttributeWithExpression(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateResourceAttributeWithExpression$str(), attribute, address);
    }
    private static final String couldNotMigrateUnsupportedAttribute = "WFLYMSG0087: Can not migrate attribute %s to resource %s. This attribute is not supported by the new messaging-activemq subsystem.";
    protected String couldNotMigrateUnsupportedAttribute$str() {
        return couldNotMigrateUnsupportedAttribute;
    }
    @Override
    public final String couldNotMigrateUnsupportedAttribute(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateUnsupportedAttribute$str(), attribute, address);
    }
    private static final String couldNotMigrateFailbackDelayAttribute = "WFLYMSG0088: Can not migrate attribute failback-delay to resource %s. Artemis detects failback deterministically and it no longer requires to specify a delay for failback to occur.";
    protected String couldNotMigrateFailbackDelayAttribute$str() {
        return couldNotMigrateFailbackDelayAttribute;
    }
    @Override
    public final String couldNotMigrateFailbackDelayAttribute(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateFailbackDelayAttribute$str(), address);
    }
}
