/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.common.expression.Expression;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.util.CodePointIterator;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public final class RemoteNamingProviderFactory
implements NamingProviderFactory {
    public static final String USE_SEPARATE_CONNECTION = "org.wildfly.naming.client.remote.use-separate-connection";
    private static final String CONNECT_OPTIONS_PREFIX = "jboss.naming.client.connect.options.";
    private static final String NAMING_CLIENT_PREFIX = "jboss.naming.client.";
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.create((Option)Options.SASL_POLICY_NOANONYMOUS, (Object)false);
    private static final String[] NO_STRINGS = new String[0];
    static final Attachments.Key<RemoteNamingProvider> PROVIDER_KEY = new Attachments.Key(RemoteNamingProvider.class);
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    @Override
    public boolean supportsUriScheme(String providerScheme, FastHashtable<String, Object> env) {
        Endpoint endpoint = this.getEndpoint(env);
        return endpoint != null && endpoint.isValidUriScheme(providerScheme);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public NamingProvider createProvider(URI providerUri, FastHashtable<String, Object> env) throws NamingException {
        classLoader = RemoteNamingProviderFactory.secureGetContextClassLoader();
        properties = RemoteNamingProviderFactory.getPropertiesFromEnv(env);
        endpoint = this.getEndpoint(env);
        callbackClass = RemoteNamingProviderFactory.getProperty(properties, "jboss.naming.client.security.callback.handler.class", null, true);
        userName = RemoteNamingProviderFactory.getProperty(properties, "java.naming.security.principal", null, true);
        password = RemoteNamingProviderFactory.getProperty(properties, "java.naming.security.credentials", null, false);
        passwordBase64 = RemoteNamingProviderFactory.getProperty(properties, "jboss.naming.client.security.password.base64", null, false);
        realm = RemoteNamingProviderFactory.getProperty(properties, "jboss.naming.client.security.realm", null, true);
        configuredConnectOptions = RemoteNamingProviderFactory.getOptionMapFromProperties(properties, "jboss.naming.client.connect.options.", classLoader);
        connectOptions = RemoteNamingProviderFactory.mergeWithDefaultOptionMap(RemoteNamingProviderFactory.DEFAULT_CONNECTION_CREATION_OPTIONS, configuredConnectOptions);
        useSeparateConnection = RemoteNamingProviderFactory.getBooleanValueFromProperties(properties, "org.wildfly.naming.client.remote.use-separate-connection", false);
        captured = AuthenticationContext.captureCurrent();
        client = RemoteNamingProviderFactory.AUTH_CONFIGURATION_CLIENT;
        operateConfiguration = client.getAuthenticationConfiguration(providerUri, captured, -1, "jndi", "jboss", useSeparateConnection != false ? null : "operate");
        if (callbackClass != null && (userName != null || password != null)) {
            throw Messages.log.callbackHandlerAndUsernameAndPasswordSpecified();
        }
        try {
            sslContext = client.getSSLContext(providerUri, captured, "jndi", "jboss", "connect");
        }
        catch (GeneralSecurityException e) {
            throw Messages.log.failedToConfigureSslContext(e);
        }
        operateConfiguration = RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)connectOptions, (AuthenticationConfiguration)operateConfiguration);
        if (callbackClass != null) {
            try {
                clazz = Class.forName(callbackClass, true, classLoader);
                callbackHandler = (CallbackHandler)clazz.newInstance();
                if (callbackHandler == null) ** GOTO lbl39
                operateConfiguration = operateConfiguration.useCallbackHandler(callbackHandler);
            }
            catch (ClassNotFoundException e) {
                throw Messages.log.failedToLoadCallbackHandlerClass(e, callbackClass);
            }
            catch (Exception e) {
                throw Messages.log.failedToInstantiateCallbackHandlerInstance(e, callbackClass);
            }
        } else if (userName != null) {
            if (password != null && passwordBase64 != null) {
                throw Messages.log.plainTextAndBase64PasswordSpecified();
            }
            decodedPassword = passwordBase64 != null ? CodePointIterator.ofString((String)passwordBase64).base64Decode().asUtf8String().drainToString() : password;
            operateConfiguration = operateConfiguration.useName(userName).usePassword(decodedPassword).useRealm(realm);
        }
lbl39:
        // 5 sources

        connectConfiguration = useSeparateConnection != false ? operateConfiguration : client.getAuthenticationConfiguration(providerUri, captured, -1, "jndi", "jboss", "connect");
        return new RemoteNamingProvider(endpoint, providerUri, connectConfiguration, operateConfiguration, sslContext, env);
    }

    private Endpoint getEndpoint(FastHashtable<String, Object> env) {
        return env.containsKey("jboss.naming.client.endpoint") ? (Endpoint)env.get("jboss.naming.client.endpoint") : Endpoint.getCurrent();
    }

    private static Properties getPropertiesFromEnv(FastHashtable<String, Object> env) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            properties.setProperty(RemoteNamingProviderFactory.processPropertyName(entry.getKey()), (String)entry.getValue());
        }
        return properties;
    }

    private static String getProperty(Properties properties, String propertyName, String defaultValue, boolean expand) {
        String str = properties.getProperty(propertyName);
        if (str == null) {
            return defaultValue;
        }
        if (expand) {
            Expression expression = Expression.compile((String)str, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX});
            return expression.evaluateWithPropertiesAndEnvironment(false);
        }
        return str.trim();
    }

    private static boolean getBooleanValueFromProperties(Properties properties, String propertyName, boolean defVal) {
        String str = RemoteNamingProviderFactory.getProperty(properties, propertyName, null, true);
        if (str == null) {
            return defVal;
        }
        return Boolean.parseBoolean(str);
    }

    private static OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix, ClassLoader classLoader) {
        return OptionMap.builder().parseAll(properties, propertyPrefix, classLoader).getMap();
    }

    private static String processPropertyName(String propertyName) {
        if (propertyName.startsWith("remote.connection.")) {
            if (propertyName.endsWith("callback.handler.class")) {
                propertyName = "jboss.naming.client.security.callback.handler.class";
            } else if (propertyName.endsWith("username")) {
                propertyName = "java.naming.security.principal";
            } else if (propertyName.endsWith("password")) {
                propertyName = "java.naming.security.credentials";
            } else if (propertyName.endsWith("password.base64")) {
                propertyName = "jboss.naming.client.security.password.base64";
            } else if (propertyName.contains("connect.options.")) {
                propertyName = NAMING_CLIENT_PREFIX + propertyName.substring(propertyName.indexOf("connect.options."));
            }
        }
        return propertyName;
    }

    private static OptionMap mergeWithDefaultOptionMap(OptionMap defaultOptions, OptionMap configuredOptions) {
        OptionMap.Builder mergedOptionMapBuilder = OptionMap.builder().addAll(configuredOptions);
        for (Option defaultOption : defaultOptions) {
            if (mergedOptionMapBuilder.getMap().contains(defaultOption)) continue;
            mergedOptionMapBuilder.set(defaultOption, defaultOptions.get(defaultOption));
        }
        return mergedOptionMapBuilder.getMap();
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(RemoteNamingProviderFactory::getContextClassLoader) : RemoteNamingProviderFactory.getContextClassLoader();
        return contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

