/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;

public abstract class AbstractContext
implements Context,
AutoCloseable {
    private static final NameParser DEFAULT_NAME_PARSER = SimpleName::new;
    private final FastHashtable<String, Object> environment;

    protected AbstractContext(FastHashtable<String, Object> environment) {
        Assert.checkNotNullParam((String)"environment", environment);
        this.environment = environment;
    }

    protected AbstractContext() {
        this(new FastHashtable<String, Object>());
    }

    public NameParser getNativeNameParser() {
        return DEFAULT_NAME_PARSER;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.lookupNative(this.getNativeNameParser().parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name instanceof CompositeName) {
            return this.lookupNative(this.decomposeName((CompositeName)name));
        }
        return this.lookupNative(name);
    }

    protected abstract Object lookupNative(Name var1) throws NamingException;

    @Override
    public Object lookupLink(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.lookupLinkNative(this.getNativeNameParser().parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name instanceof CompositeName) {
            return this.lookupLinkNative(this.decomposeName((CompositeName)name));
        }
        return this.lookupLinkNative(name);
    }

    protected abstract Object lookupLinkNative(Name var1) throws NamingException;

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.bind(this.getNativeNameParser().parse(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            this.bind(this.decomposeName((CompositeName)name), obj);
        } else {
            this.bindNative(name, obj);
        }
    }

    protected void bindNative(Name name, Object obj) throws NamingException {
        throw AbstractContext.readOnlyContext();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.rebind(this.getNativeNameParser().parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            this.rebind(this.decomposeName((CompositeName)name), obj);
        } else {
            this.rebindNative(name, obj);
        }
    }

    protected void rebindNative(Name name, Object obj) throws NamingException {
        throw AbstractContext.readOnlyContext();
    }

    @Override
    public void unbind(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.unbind(this.getNativeNameParser().parse(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            this.unbind(this.decomposeName((CompositeName)name));
        } else {
            this.unbindNative(name);
        }
    }

    protected void unbindNative(Name name) throws NamingException {
        throw AbstractContext.readOnlyContext();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Assert.checkNotNullParam((String)"oldName", (Object)oldName);
        Assert.checkNotNullParam((String)"newName", (Object)newName);
        this.renameNative(this.getNativeNameParser().parse(oldName), this.getNativeNameParser().parse(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Assert.checkNotNullParam((String)"oldName", (Object)oldName);
        Assert.checkNotNullParam((String)"newName", (Object)newName);
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        Name nativeOldName = oldName instanceof CompositeName ? this.decomposeName((CompositeName)oldName) : oldName;
        Name nativeNewName = newName instanceof CompositeName ? this.decomposeName((CompositeName)newName) : newName;
        if (nativeOldName.isEmpty() || nativeNewName.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        this.rebindNative(nativeOldName, nativeNewName);
    }

    protected void renameNative(Name oldName, Name newName) throws NamingException {
        throw AbstractContext.readOnlyContext();
    }

    public CloseableNamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.listNative(this.getNativeNameParser().parse(name));
    }

    public CloseableNamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name instanceof CompositeName) {
            return this.listNative(this.decomposeName((CompositeName)name));
        }
        return this.listNative(name);
    }

    protected abstract CloseableNamingEnumeration<NameClassPair> listNative(Name var1) throws NamingException;

    public CloseableNamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.listBindingsNative(this.getNativeNameParser().parse(name));
    }

    public CloseableNamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name instanceof CompositeName) {
            return this.listBindingsNative(this.decomposeName((CompositeName)name));
        }
        return this.listBindingsNative(name);
    }

    protected abstract CloseableNamingEnumeration<Binding> listBindingsNative(Name var1) throws NamingException;

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.destroySubcontext(this.getNativeNameParser().parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            this.destroySubcontext(this.decomposeName((CompositeName)name));
        } else {
            this.destroySubcontextNative(name);
        }
    }

    protected void destroySubcontextNative(Name name) throws NamingException {
        throw AbstractContext.readOnlyContext();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.createSubcontext(this.getNativeNameParser().parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            return this.createSubcontext(this.decomposeName((CompositeName)name));
        }
        return this.createSubcontextNative(name);
    }

    protected Context createSubcontextNative(Name name) throws NamingException {
        throw AbstractContext.readOnlyContext();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name base = prefix instanceof CompositeName ? this.decomposeName((CompositeName)prefix) : (Name)prefix.clone();
        if (name instanceof CompositeName) {
            base.addAll(this.decomposeName((CompositeName)name));
        } else {
            base.addAll(name);
        }
        return base;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"prefix", (Object)prefix);
        return this.composeName(this.getNativeNameParser().parse(name), this.getNativeNameParser().parse(prefix)).toString();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNativeNameParser();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNativeNameParser();
    }

    protected Name decomposeName(CompositeName compositeName) throws NamingException {
        NameParser parser = this.getNativeNameParser();
        if (compositeName.isEmpty()) {
            return parser.parse("");
        }
        Name name = parser.parse(compositeName.get(0));
        if (name.isEmpty()) {
            name.add("");
        }
        for (int i = 1; i < compositeName.size(); ++i) {
            String part = compositeName.get(i);
            Name parsed = parser.parse(part);
            if (parsed.isEmpty()) {
                parsed.add("");
            }
            name.addAll(parsed);
        }
        return name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public FastHashtable<String, Object> getEnvironment() throws NamingException {
        return this.environment;
    }

    protected static NamingException nameNotFound(Name name) {
        return Messages.log.nameNotFound(name, name);
    }

    protected static NoPermissionException readOnlyContext() {
        return Messages.log.readOnlyContext();
    }

    protected static OperationNotSupportedException notSupported() {
        return Messages.log.notSupported();
    }
}

