/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.logging.syslogserver;

import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import org.jboss.as.test.integration.logging.syslogserver.TCPSyslogSocketHandler;
import org.jboss.logging.Logger;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.impl.net.tcp.TCPNetSyslogServer;

public class TCPSyslogServer
extends TCPNetSyslogServer {
    private static final Logger LOGGER = Logger.getLogger(TCPSyslogServer.class);

    public TCPSyslogServer() {
        this.sockets = Collections.synchronizedSet(this.sockets);
    }

    public void run() {
        try {
            LOGGER.debug((Object)"Creating Syslog server socket");
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException e) {
            LOGGER.error((Object)"ServerSocket creation failed.", (Throwable)e);
            throw new SyslogRuntimeException((Throwable)e);
        }
        while (!this.shutdown) {
            try {
                Socket socket = this.serverSocket.accept();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Handling Syslog client " + socket.getInetAddress()));
                }
                new Thread(new TCPSyslogSocketHandler(this.sockets, (SyslogServerIF)this, socket)).start();
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException occurred.", (Throwable)e);
            }
        }
    }
}

