/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.util.Random;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.jboss.as.security.vault.VaultSession;
import org.jboss.logging.Logger;
import org.picketbox.util.KeyStoreUtil;

public class VaultHandler {
    private static Logger LOGGER = Logger.getLogger(VaultHandler.class);
    public static final String ENC_DAT_FILE = "ENC.dat";
    public static final String SHARED_DAT_FILE = "Shared.dat";
    public static final String VAULT_DAT_FILE = "VAULT.dat";
    public static final String DEFAULT_KEYSTORE_FILE = "vault.keystore";
    private String encodedVaultFileDirectory;
    private String keyStoreType;
    private String keyStore;
    private String keyStorePassword;
    private int keySize = 128;
    private String alias = "defaultalias";
    private String salt;
    private int iterationCount;
    private VaultSession vaultSession;
    private static String FILE_SEPARATOR = System.getProperty("file.separator");
    private static String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static String DEFAULT_PASSWORD = "super_secret";

    public VaultHandler(String keyStore, String keyStorePassword, String keyStoreType, String encodedVaultFileDirectory, int keySize, String alias, String salt, int iterationCount) {
        if (alias != null) {
            this.alias = alias;
        }
        if (keySize != 0) {
            this.keySize = keySize;
        }
        if (keyStoreType == null) {
            this.keyStoreType = "JCEKS";
        } else {
            if (!keyStoreType.equals("JCEKS") && !keyStoreType.equals("JKS")) {
                throw new IllegalArgumentException("Wrong keyStoreType. Supported are only (JCEKS or JKS). Preferred is JCEKS.");
            }
            this.keyStoreType = keyStoreType;
        }
        if (keyStorePassword == null) {
            this.keyStorePassword = DEFAULT_PASSWORD;
        } else {
            if (keyStorePassword.startsWith("MASK-")) {
                throw new IllegalArgumentException("keyStorePassword cannot be a masked password, use plain text password, please");
            }
            this.keyStorePassword = keyStorePassword;
        }
        try {
            File keyStoreFile = new File(keyStore);
            if (!keyStoreFile.exists()) {
                if (!this.keyStoreType.equals("JCEKS")) {
                    throw new RuntimeException("keyStoreType has to be JCEKS when creating new key store");
                }
                File keyStoreParent = keyStoreFile.getAbsoluteFile().getParentFile();
                if (keyStoreParent != null && (!keyStoreParent.exists() ? !$assertionsDisabled && !keyStoreParent.mkdirs() : !$assertionsDisabled && !keyStoreParent.isDirectory())) {
                    throw new AssertionError();
                }
                KeyStore ks = KeyStoreUtil.createKeyStore((String)this.keyStoreType, (char[])this.keyStorePassword.toCharArray());
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(this.keySize);
                SecretKey secretKey = keyGenerator.generateKey();
                KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(secretKey);
                KeyStore.PasswordProtection p = new KeyStore.PasswordProtection(this.keyStorePassword.toCharArray());
                ks.setEntry(this.alias, skEntry, p);
                ks.store(new FileOutputStream(keyStoreFile), this.keyStorePassword.toCharArray());
            }
            this.keyStore = keyStoreFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem creating keyStore: ", e);
        }
        File vaultDirectory = new File(encodedVaultFileDirectory).getAbsoluteFile();
        if (!vaultDirectory.exists()) {
            assert (vaultDirectory.mkdirs());
        } else if (!vaultDirectory.isDirectory()) {
            throw new RuntimeException("Vault encryption directory has to be directory, but " + vaultDirectory.getAbsolutePath() + " is not.");
        }
        this.encodedVaultFileDirectory = vaultDirectory.getAbsolutePath();
        if (salt == null) {
            String tmp = Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.currentTimeMillis());
            this.salt = tmp.substring(0, 8);
        } else {
            this.salt = salt;
        }
        this.iterationCount = iterationCount <= 0 ? new Random().nextInt(90) + 1 : iterationCount;
        if (LOGGER.isDebugEnabled()) {
            this.logCreatedVault();
        }
        try {
            this.vaultSession = new VaultSession(this.keyStore, this.keyStorePassword, this.encodedVaultFileDirectory, this.salt, this.iterationCount);
            this.vaultSession.startVaultSession(this.alias);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem creating VaultSession: ", e);
        }
        LOGGER.debug((Object)"VaultSession started");
    }

    public VaultHandler(String keyStore, String encodedVaultFileDirectory) {
        this(keyStore, null, null, encodedVaultFileDirectory, 0, null, null, 0);
    }

    public VaultHandler(String encodedVaultFileDirectory) {
        this(VaultHandler.getDefaultKeystoreFile(encodedVaultFileDirectory), encodedVaultFileDirectory);
    }

    public VaultHandler() {
        this(TMP_DIR);
    }

    public String getMaskedKeyStorePassword() {
        if (this.vaultSession != null) {
            return this.vaultSession.getKeystoreMaskedPassword();
        }
        throw new RuntimeException("getMaskedKeyStorePassword: Vault inside this handler is not initialized or created");
    }

    public String addSecuredAttribute(String vaultBlock, String attributeName, char[] attributeValue) {
        if (this.vaultSession != null) {
            try {
                return this.vaultSession.addSecuredAttribute(vaultBlock, attributeName, attributeValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("addSecuredAttribute: Vault inside this handler is not initialized or created");
    }

    public boolean exists(String vaultBlock, String attributeName) {
        if (this.vaultSession != null) {
            try {
                return this.vaultSession.checkSecuredAttribute(vaultBlock, attributeName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("exists: Vault inside this handler is not initialized or created");
    }

    public VaultSession getVaultSession() {
        return this.vaultSession;
    }

    public void cleanUp() {
        VaultHandler.cleanFilesystem(this.encodedVaultFileDirectory, false, this.keyStore);
        this.vaultSession = null;
    }

    public String getEncodedVaultFileDirectory() {
        return this.encodedVaultFileDirectory;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public String getIterationCountAsString() {
        return Integer.toString(this.iterationCount);
    }

    private void logCreatedVault() {
        LOGGER.debug((Object)("keystoreURL=" + this.keyStore));
        LOGGER.debug((Object)("KEYSTORE_PASSWORD=" + this.keyStorePassword));
        LOGGER.debug((Object)("ENC_FILE_DIR=" + this.encodedVaultFileDirectory));
        LOGGER.debug((Object)("KEYSTORE_ALIAS=" + this.alias));
        LOGGER.debug((Object)("SALT=" + this.salt));
        LOGGER.debug((Object)("ITERATION_COUNT=" + this.iterationCount));
    }

    private static String getDefaultKeystoreFile(String encodedVaultFileDirectory) {
        return encodedVaultFileDirectory + FILE_SEPARATOR + DEFAULT_KEYSTORE_FILE;
    }

    public static void cleanFilesystem(String encodedVaultFileDirectory, boolean removeEncodedVaultFileDirectory) {
        VaultHandler.cleanFilesystem(encodedVaultFileDirectory, removeEncodedVaultFileDirectory, VaultHandler.getDefaultKeystoreFile(encodedVaultFileDirectory));
    }

    public static void cleanFilesystem(String encodedVaultFileDirectory, boolean removeEncodedVaultFileDirectory, String keyStore) {
        VaultHandler.cleanFilesystem(new File(encodedVaultFileDirectory), removeEncodedVaultFileDirectory, new File(keyStore));
    }

    private static void cleanFilesystem(File encodedVaultFileDirectory, boolean removeEncodedVaultFileDirectory, File keyStore) {
        VaultHandler.deleteIfExists(keyStore);
        File f = new File(keyStore.getParent(), keyStore.getName() + ".original");
        VaultHandler.deleteIfExists(f);
        if (removeEncodedVaultFileDirectory) {
            VaultHandler.deleteDirectory(encodedVaultFileDirectory);
        } else {
            VaultHandler.cleanEncodedVaultFileDirectory(encodedVaultFileDirectory);
        }
    }

    private static void deleteDirectory(File f) {
        File[] children;
        File[] fileArray = children = f.isDirectory() ? f.listFiles() : null;
        if (children != null) {
            for (File child : children) {
                VaultHandler.deleteDirectory(child);
            }
        }
        VaultHandler.deleteIfExists(f);
    }

    private static void cleanEncodedVaultFileDirectory(File encodedVaultFileDirectory) {
        File f = new File(encodedVaultFileDirectory, VAULT_DAT_FILE);
        VaultHandler.deleteIfExists(f);
        f = new File(encodedVaultFileDirectory, ENC_DAT_FILE);
        VaultHandler.deleteIfExists(f);
        f = new File(encodedVaultFileDirectory, "ENC.dat.original");
        VaultHandler.deleteIfExists(f);
        f = new File(encodedVaultFileDirectory, SHARED_DAT_FILE);
        VaultHandler.deleteIfExists(f);
        f = new File(encodedVaultFileDirectory, "KEYSTORE_README");
        VaultHandler.deleteIfExists(f);
    }

    private static void deleteIfExists(File f) {
        assert (!f.exists() || f.delete());
    }
}

