/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.PermissionMapper;
import org.wildfly.test.security.common.elytron.PermissionRef;

public class SimplePermissionMapper
extends AbstractConfigurableElement
implements PermissionMapper {
    private final List<PermissionMapping> mappings;
    private final PermissionMapper.MappingMode mappingMode;

    private SimplePermissionMapper(Builder builder) {
        super(builder);
        this.mappings = builder.mappings;
        this.mappingMode = builder.mappingMode;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder cliCommand = new StringBuilder();
        cliCommand.append("/subsystem=elytron/simple-permission-mapper=").append(this.name).append(":add(");
        if (this.mappingMode != null) {
            cliCommand.append("mapping-mode=").append(this.mappingMode.toString()).append(",");
        }
        cliCommand.append("permission-mappings=[");
        cliCommand.append(this.mappings.stream().map(PermissionMapping::toCLIString).collect(Collectors.joining(",")));
        cliCommand.append("]");
        cliCommand.append(")");
        cli.sendLine(cliCommand.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine("/subsystem=elytron/simple-permission-mapper=" + this.name + ":remove");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class PermissionMapping {
        private final List<PermissionRef> permissions;
        private final List<String> principals;
        private final List<String> roles;

        private PermissionMapping(Builder builder) {
            this.permissions = builder.permissions;
            this.principals = builder.principals;
            this.roles = builder.roles;
        }

        public List<PermissionRef> getPermissions() {
            return this.permissions;
        }

        public List<String> getPrincipals() {
            return this.principals;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toCLIString() {
            StringBuilder result = new StringBuilder();
            result.append("{permissions=[");
            result.append(this.permissions.stream().map(PermissionRef::toCLIString).collect(Collectors.joining(",")));
            result.append("]");
            if (this.principals.size() > 0) {
                result.append(",principals=[");
                result.append(StringUtils.join(this.principals, (String)","));
                result.append("]");
            }
            if (this.roles.size() > 0) {
                result.append(",roles=[");
                result.append(StringUtils.join(this.roles, (String)","));
                result.append("]");
            }
            result.append("}");
            return result.toString();
        }

        public static final class Builder {
            private List<PermissionRef> permissions = new ArrayList<PermissionRef>();
            private List<String> principals = new ArrayList<String>();
            private List<String> roles = new ArrayList<String>();

            public Builder withPermissions(PermissionRef ... permissions) {
                this.permissions.addAll(Arrays.asList(permissions));
                return this;
            }

            public Builder withPrincipals(String ... principals) {
                this.principals.addAll(Arrays.asList(principals));
                return this;
            }

            public Builder withRoles(String ... roles) {
                this.roles.addAll(Arrays.asList(roles));
                return this;
            }

            public PermissionMapping build() {
                return new PermissionMapping(this);
            }
        }
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private PermissionMapper.MappingMode mappingMode;
        private List<PermissionMapping> mappings = new ArrayList<PermissionMapping>();

        @Override
        protected Builder self() {
            return this;
        }

        public SimplePermissionMapper build() {
            return new SimplePermissionMapper(this);
        }

        public Builder mappingMode(PermissionMapper.MappingMode mappingMode) {
            this.mappingMode = mappingMode;
            return this;
        }

        public Builder permissionMapping(PermissionMapping mapping) {
            this.mappings.add(mapping);
            return this;
        }

        public Builder permissionMappings(PermissionMapping ... mappings) {
            this.mappings.addAll(Arrays.asList(mappings));
            return this;
        }
    }
}

