/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingleton;
import org.jboss.logging.Logger;

public class TestXAResource
implements XAResource {
    private static Logger log = Logger.getLogger(TestXAResource.class);
    protected TestAction testAction = TestAction.NONE;
    private TransactionCheckerSingleton checker;
    private int transactionTimeout;

    public TestXAResource(TransactionCheckerSingleton checker) {
        this.checker = checker;
    }

    public TestXAResource(TestAction testAction, TransactionCheckerSingleton checker) {
        this.checker = checker;
        this.testAction = testAction;
    }

    public TestXAResource(TestAction testAction) {
        this.checker = new TransactionCheckerSingleton();
        this.testAction = testAction;
    }

    public TestXAResource() {
        this(TestAction.NONE);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        log.tracef("prepare xid: [%s]", (Object)xid);
        this.checker.addPrepare();
        switch (this.testAction) {
            case PREPARE_THROW_XAER_RMERR: {
                throw new XAException(-3);
            }
            case PREPARE_THROW_XAER_RMFAIL: {
                throw new XAException(-7);
            }
            case PREPARE_THROW_UNKNOWN_XA_EXCEPTION: {
                throw new XAException(null);
            }
        }
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.tracef("commit xid:[%s], %s one phase", (Object)xid, (Object)(onePhase ? "with" : "without"));
        this.checker.addCommit();
        switch (this.testAction) {
            case COMMIT_THROW_XAER_RMERR: {
                throw new XAException(-3);
            }
            case COMMIT_THROW_XAER_RMFAIL: {
                throw new XAException(-7);
            }
            case COMMIT_THROW_UNKNOWN_XA_EXCEPTION: {
                throw new XAException(null);
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        log.tracef("end xid:[%s], flag: %s", (Object)xid, (Object)flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.tracef("forget xid:[%s]", (Object)xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        log.tracef("getTransactionTimeout: returning timeout: %s", this.transactionTimeout);
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        log.tracef("isSameRM returning false to xares: %s", (Object)xares);
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        log.tracef("recover with flags: %s", flag);
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        log.tracef("rollback xid: [%s]", (Object)xid);
        this.checker.addRollback();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        log.tracef("setTransactionTimeout: setting timeout: %s", seconds);
        this.transactionTimeout = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        log.tracef("start xid: [%s], flags: %s", (Object)xid, (Object)flags);
    }

    public static enum TestAction {
        NONE,
        PREPARE_THROW_XAER_RMERR,
        PREPARE_THROW_XAER_RMFAIL,
        PREPARE_THROW_UNKNOWN_XA_EXCEPTION,
        COMMIT_THROW_XAER_RMERR,
        COMMIT_THROW_XAER_RMFAIL,
        COMMIT_THROW_UNKNOWN_XA_EXCEPTION;

    }
}

