/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.apache.commons.lang3.StringUtils;
import org.jboss.as.test.shared.CliUtils;
import org.wildfly.test.security.common.elytron.CliFragment;

public class Path
implements CliFragment {
    public static final Path EMPTY = Path.builder().build();
    private final String path;
    private final String relativeTo;

    private Path(Builder builder) {
        this.path = builder.path;
        this.relativeTo = builder.relativeTo;
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.path)) {
            sb.append(String.format("path=\"%s\", ", CliUtils.escapePath(this.path)));
            if (StringUtils.isNotBlank((CharSequence)this.relativeTo)) {
                sb.append(String.format("relative-to=\"%s\"", this.relativeTo));
            }
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String path;
        private String relativeTo;

        private Builder() {
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withRelativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public Path build() {
            return new Path(this);
        }
    }
}

