/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Properties;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.CredentialReference;

public class SimpleAuthConfig
extends AbstractConfigurableElement {
    private final Boolean anonymous;
    private final Boolean allowAllMechanisms;
    private final String[] allowSaslMechanisms;
    private final String[] forbidSaslMechanisms;
    private final Properties mechanismProperties;
    private final String authenticationName;
    private final String authorizationName;
    private final CredentialReference credentialReference;
    private final String extendsAttr;
    private final String host;
    private final String port;
    private final String protocol;
    private final String realm;
    private final String securityDomain;

    private SimpleAuthConfig(Builder builder) {
        super(builder);
        this.anonymous = builder.anonymous;
        this.allowAllMechanisms = builder.allowAllMechanisms;
        this.allowSaslMechanisms = builder.allowSaslMechanisms;
        this.forbidSaslMechanisms = builder.forbidSaslMechanisms;
        this.mechanismProperties = builder.mechanismProperties;
        this.authenticationName = builder.authenticationName;
        this.authorizationName = builder.authorizationName;
        this.credentialReference = builder.credentialReference;
        this.extendsAttr = builder.extendsAttr;
        this.host = builder.host;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.realm = builder.realm;
        this.securityDomain = builder.securityDomain;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder sb = new StringBuilder("/subsystem=elytron/authentication-configuration=\"");
        sb.append(this.name).append("\":add(");
        if (this.anonymous != null) {
            sb.append(this.anonymous == true ? "" : "!").append("anonymous, ");
        }
        if (this.allowAllMechanisms != null) {
            sb.append(this.allowAllMechanisms == true ? "" : "!").append("allow-all-mechanisms, ");
        }
        if (this.allowSaslMechanisms != null && this.allowSaslMechanisms.length > 0) {
            sb.append("allow-sasl-mechanisms=[");
            for (String string : this.allowSaslMechanisms) {
                sb.append(string).append(" ");
            }
            sb.append("], ");
        }
        if (this.forbidSaslMechanisms != null && this.forbidSaslMechanisms.length > 0) {
            sb.append("forbid-sasl-mechanisms=[");
            for (String string : this.forbidSaslMechanisms) {
                sb.append(string).append(" ");
            }
            sb.append("], ");
        }
        if (this.mechanismProperties != null && !this.mechanismProperties.isEmpty()) {
            sb.append("mechanism-properties={");
            for (Object e : this.mechanismProperties.keySet()) {
                sb.append(e.toString()).append("=").append(this.mechanismProperties.getProperty(e.toString()));
                sb.append(", ");
            }
            sb.append("}, ");
        }
        if (this.authenticationName != null && !this.authenticationName.isEmpty()) {
            sb.append(String.format("authentication-name=\"%s\", ", this.authenticationName));
        }
        if (this.authorizationName != null && !this.authorizationName.isEmpty()) {
            sb.append(String.format("authorization-name=\"%s\", ", this.authorizationName));
        }
        if (this.credentialReference != null) {
            sb.append(this.credentialReference.asString());
        }
        if (this.extendsAttr != null && !this.extendsAttr.isEmpty()) {
            sb.append(String.format("extends=\"%s\", ", this.extendsAttr));
        }
        if (this.host != null && !this.host.isEmpty()) {
            sb.append(String.format("host=\"%s\", ", this.host));
        }
        if (this.port != null && !this.port.isEmpty()) {
            sb.append(String.format("port=\"%s\", ", this.port));
        }
        if (this.protocol != null && !this.protocol.isEmpty()) {
            sb.append(String.format("protocol=\"%s\", ", this.protocol));
        }
        if (this.realm != null && !this.realm.isEmpty()) {
            sb.append(String.format("realm=\"%s\", ", this.realm));
        }
        if (this.securityDomain != null && !this.securityDomain.isEmpty()) {
            sb.append(String.format("security-domain=\"%s\", ", this.securityDomain));
        }
        sb.append(")");
        cli.sendLine(sb.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/authentication-configuration=\"%s\":remove", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private Boolean anonymous;
        private Boolean allowAllMechanisms;
        private String[] allowSaslMechanisms;
        private String[] forbidSaslMechanisms;
        private Properties mechanismProperties;
        private String authenticationName;
        private String authorizationName;
        private CredentialReference credentialReference;
        private String extendsAttr;
        private String host;
        private String port;
        private String protocol;
        private String realm;
        private String securityDomain;

        private Builder() {
        }

        public Builder allowAnonymous(Boolean allowAnonymous) {
            this.anonymous = allowAnonymous;
            return this;
        }

        public Builder allowAllMechanisms(Boolean allowAllMechanisms) {
            this.allowAllMechanisms = allowAllMechanisms;
            return this;
        }

        public Builder withAllowedSaslMechanisms(String ... allowedSaslMechanisms) {
            this.allowSaslMechanisms = allowedSaslMechanisms;
            return this;
        }

        public Builder withForbiddenSaslMechanisms(String ... forbiddenSaslMechanisms) {
            this.forbidSaslMechanisms = forbiddenSaslMechanisms;
            return this;
        }

        public Builder withMechanismProperties(Properties mechanismProperties) {
            this.mechanismProperties = mechanismProperties;
            return this;
        }

        public Builder withAuthenticationName(String authenticationName) {
            this.authenticationName = authenticationName;
            return this;
        }

        public Builder withAuthorizationName(String authorizationName) {
            this.authorizationName = authorizationName;
            return this;
        }

        public Builder withCredentialReference(CredentialReference credentialReference) {
            this.credentialReference = credentialReference;
            return this;
        }

        public Builder withExtends(String extendsAttr) {
            this.extendsAttr = extendsAttr;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(String port) {
            this.port = port;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder withSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public SimpleAuthConfig build() {
            return new SimpleAuthConfig(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

