/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.as.test.shared.integration.ejb.security.Util;
import org.jboss.logging.Logger;

public final class TransactionTestLookupUtil {
    private static final Logger log = Logger.getLogger(TransactionTestLookupUtil.class);

    private TransactionTestLookupUtil() {
    }

    public static <T> T lookupModule(InitialContext ctx, Class<T> beanType) throws NamingException {
        String lookupString = String.format("java:module/%s!%s", beanType.getSimpleName(), beanType.getName());
        log.debug((Object)("looking for: " + lookupString));
        return beanType.cast(ctx.lookup(lookupString));
    }

    public static <T> T lookupEjbStateless(InitialContext ctx, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException {
        return TransactionTestLookupUtil.lookupEjb(ctx, archiveName, beanType, remoteInterface, false);
    }

    public static <T> T lookupEjbStateful(InitialContext ctx, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException {
        return TransactionTestLookupUtil.lookupEjb(ctx, archiveName, beanType, remoteInterface, true);
    }

    public static <T> T lookupEjbStateless(String host, int port, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException {
        return TransactionTestLookupUtil.lookupEjb(host, port, archiveName, beanType, remoteInterface, false);
    }

    public static <T> T lookupEjbStateful(String host, int port, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException {
        return TransactionTestLookupUtil.lookupEjb(host, port, archiveName, beanType, remoteInterface, true);
    }

    public static <T> T lookupIIOP(String serverHost, int iiopPort, Class<T> homeClass, Class<?> beanClass) throws NamingException {
        Properties prope = new Properties();
        prope.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        prope.setProperty("java.naming.factory.url.pkgs", "org.jboss.iiop.naming:org.jboss.naming.client");
        prope.put("java.naming.provider.url", "corbaloc::" + serverHost + ":" + iiopPort + "/JBoss/Naming/root");
        InitialContext context = new InitialContext(prope);
        Object ejbHome = context.lookup(beanClass.getSimpleName());
        return homeClass.cast(PortableRemoteObject.narrow((Object)ejbHome, homeClass));
    }

    private static <T> T lookupEjb(InitialContext ctx, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface, boolean isStateful) throws NamingException {
        String ejbLookup = Util.createRemoteEjbJndiContext("", archiveName, "", beanType.getSimpleName(), remoteInterface.getName(), isStateful);
        log.debug((Object)("looking for: " + ejbLookup));
        return remoteInterface.cast(ctx.lookup(ejbLookup));
    }

    private static <T> T lookupEjb(String host, int port, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface, boolean isStateful) throws NamingException {
        InitialContext ctx = new InitialContext(TransactionTestLookupUtil.getEjbClientProperties(host, port));
        return TransactionTestLookupUtil.lookupEjb(ctx, archiveName, beanType, remoteInterface, isStateful);
    }

    private static Properties getEjbClientProperties(String node, int port) {
        Properties props = new Properties();
        props.put("org.jboss.ejb.client.scoped.context", (Object)true);
        props.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        props.put("endpoint.name", "client");
        props.put("remote.connections", "main");
        props.put("remote.connection.main.host", node);
        props.put("remote.connection.main.port", Integer.toString(port));
        props.put("remote.connection.main.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS", "false");
        props.put("remote.connection.main.connect.options.org.xnio.Options.SASL_POLICY_NOPLAINTEXT", "true");
        props.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
        return props;
    }
}

