/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingletonRemote;

@Singleton
@LocalBean
public class TransactionCheckerSingleton
implements TransactionCheckerSingletonRemote {
    private final AtomicInteger committed = new AtomicInteger();
    private final AtomicInteger prepared = new AtomicInteger();
    private final AtomicInteger rolledback = new AtomicInteger();
    private final AtomicInteger synchronizedBegin = new AtomicInteger();
    private final AtomicInteger synchronizedBefore = new AtomicInteger();
    private final AtomicInteger synchronizedAfter = new AtomicInteger();
    private final AtomicInteger synchronizedAfterCommitted = new AtomicInteger();
    private final AtomicInteger synchronizedAfterRolledBack = new AtomicInteger();
    private final Map<String, String> messages = new ConcurrentHashMap<String, String>();

    @Override
    public int getCommitted() {
        return this.committed.get();
    }

    @Override
    public void addCommit() {
        this.committed.incrementAndGet();
    }

    @Override
    public int getPrepared() {
        return this.prepared.get();
    }

    @Override
    public void addPrepare() {
        this.prepared.incrementAndGet();
    }

    @Override
    public int getRolledback() {
        System.out.println("returning rollback value " + this.rolledback.get() + "!::" + this);
        return this.rolledback.get();
    }

    @Override
    public void addRollback() {
        System.out.println("incrementing rollback value!::" + this);
        this.rolledback.incrementAndGet();
    }

    @Override
    public boolean isSynchronizedBefore() {
        return this.synchronizedBefore.get() > 0;
    }

    @Override
    public void setSynchronizedBefore() {
        this.synchronizedBefore.incrementAndGet();
    }

    @Override
    public boolean isSynchronizedAfter() {
        return this.synchronizedAfter.get() > 0;
    }

    @Override
    public void setSynchronizedAfter(boolean isCommit) {
        this.synchronizedAfter.incrementAndGet();
        if (isCommit) {
            this.synchronizedAfterCommitted.incrementAndGet();
        } else {
            this.synchronizedAfterRolledBack.incrementAndGet();
        }
    }

    @Override
    public boolean isSynchronizedBegin() {
        return this.synchronizedBegin.get() > 0;
    }

    @Override
    public void setSynchronizedBegin() {
        this.synchronizedBegin.incrementAndGet();
    }

    @Override
    public void resetCommitted() {
        this.committed.set(0);
    }

    @Override
    public void resetPrepared() {
        this.prepared.set(0);
    }

    @Override
    public void resetRolledback() {
        System.out.println("rollback reset! ::" + this);
        this.rolledback.set(0);
    }

    @Override
    public void resetSynchronizedBefore() {
        this.synchronizedBefore.set(0);
    }

    @Override
    public void resetSynchronizedAfter() {
        this.synchronizedAfter.set(0);
        this.synchronizedAfterCommitted.set(0);
        this.synchronizedAfterRolledBack.set(0);
    }

    @Override
    public void resetSynchronizedBegin() {
        this.synchronizedBegin.set(0);
    }

    @Override
    public int countSynchronizedBefore() {
        return this.synchronizedBefore.get();
    }

    @Override
    public int countSynchronizedAfter() {
        return this.synchronizedAfter.get();
    }

    @Override
    public int countSynchronizedAfterCommitted() {
        return this.synchronizedAfterCommitted.get();
    }

    @Override
    public int countSynchronizedAfterRolledBack() {
        return this.synchronizedAfterRolledBack.get();
    }

    @Override
    public int countSynchronizedBegin() {
        return this.synchronizedBegin.get();
    }

    @Override
    public void addMessage(String msg) {
        this.messages.put(msg, msg);
    }

    @Override
    public Collection<String> getMessages() {
        return this.messages.values();
    }

    @Override
    public void resetMessages() {
        this.messages.clear();
    }

    @Override
    public void resetAll() {
        this.resetCommitted();
        this.resetPrepared();
        this.resetRolledback();
        this.resetSynchronizedAfter();
        this.resetSynchronizedBefore();
        this.resetSynchronizedBegin();
        this.resetMessages();
    }
}

