/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.ConfigurableElement;
import org.wildfly.test.security.common.elytron.CredentialReference;

public class DirContext
implements ConfigurableElement {
    private final PathAddress address;
    private final String name;
    private final String url;
    private final AuthenticationLevel authenticationLevel;
    private final String principal;
    private final Boolean enableConnectionPooling;
    private final String sslContext;
    private final ReferralMode referralMode;
    private final String authenticationContext;
    private final Integer connectionTimeout;
    private final Integer readTimeout;
    private final String module;
    private final List<Property> properties;
    private final CredentialReference credentialReference;

    DirContext(Builder builder) {
        this.name = builder.name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"dir-context", (String)this.name)});
        this.url = builder.url;
        this.authenticationLevel = builder.authenticationLevel;
        this.principal = builder.principal;
        this.enableConnectionPooling = builder.enableConnectionPooling;
        this.sslContext = builder.sslContext;
        this.referralMode = builder.referralMode;
        this.authenticationContext = builder.authenticationContext;
        this.connectionTimeout = builder.connectionTimeout;
        this.readTimeout = builder.readTimeout;
        this.module = builder.module;
        this.properties = builder.properties;
        this.credentialReference = builder.credentialReference;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModelNode getAddOperation() {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        addOperation.get("dir-context");
        if (this.url != null) {
            addOperation.get("url").set(this.url);
        }
        if (this.authenticationLevel != null) {
            addOperation.get("authentication-level").set(this.authenticationLevel == null ? null : this.authenticationLevel.name());
        }
        if (this.principal != null) {
            addOperation.get("principal").set(this.principal);
        }
        if (this.enableConnectionPooling != null) {
            addOperation.get("enable-connection-pooling").set(this.enableConnectionPooling.booleanValue());
        }
        if (this.sslContext != null) {
            addOperation.get("ssl-context").set(this.sslContext);
        }
        if (this.referralMode != null) {
            addOperation.get("referral-mode").set(this.referralMode == null ? null : this.referralMode.name());
        }
        if (this.authenticationContext != null) {
            addOperation.get("authentication-context").set(this.authenticationContext);
        }
        if (this.connectionTimeout != null) {
            addOperation.get("connection-timeout").set(this.connectionTimeout.intValue());
        }
        if (this.readTimeout != null) {
            addOperation.get("read-timeout").set(this.readTimeout.intValue());
        }
        if (this.module != null) {
            addOperation.get("module").set(this.module);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            ModelNode propertiesNode = new ModelNode();
            for (Property property : this.properties) {
                propertiesNode.add(property.getKey(), property.getValue());
            }
            addOperation.get("properties").set(propertiesNode.asObject());
        }
        if (this.credentialReference != null) {
            addOperation.get("credential-reference").set(this.credentialReference.asModelNode());
        }
        return addOperation;
    }

    public ModelNode getRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)this.address);
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getAddOperation(), client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getRemoveOperation(), client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static enum ReferralMode {
        FOLLOW,
        IGNORE,
        THROW;

    }

    public static enum AuthenticationLevel {
        NONE,
        SIMPLE,
        STRONG;

    }

    public static class Property {
        private final String key;
        private final String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class Builder {
        private final String name;
        private String url;
        private AuthenticationLevel authenticationLevel;
        private String principal;
        private Boolean enableConnectionPooling;
        private String sslContext;
        private ReferralMode referralMode;
        private String authenticationContext;
        private Integer connectionTimeout;
        private Integer readTimeout;
        private String module;
        private List<Property> properties = new ArrayList<Property>();
        private CredentialReference credentialReference;

        public Builder(String name) {
            this.name = name;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withAuthenticationLevel(AuthenticationLevel authenticationLevel) {
            this.authenticationLevel = authenticationLevel;
            return this;
        }

        public Builder withPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public Builder withEnableConnectionPooling(boolean enableConnectionPooling) {
            this.enableConnectionPooling = enableConnectionPooling;
            return this;
        }

        public Builder withSslContext(String sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withReferralMode(ReferralMode referralMode) {
            this.referralMode = referralMode;
            return this;
        }

        public Builder withAuthenticationContext(String authenticationContext) {
            this.authenticationContext = authenticationContext;
            return this;
        }

        public Builder withConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withModule(String module) {
            this.module = module;
            return this;
        }

        public Builder withProperties(Property ... properties) {
            Collections.addAll(this.properties, properties);
            return this;
        }

        public Builder withCredentialReference(CredentialReference credentialReference) {
            this.credentialReference = credentialReference;
            return this;
        }

        public DirContext build() {
            return new DirContext(this);
        }
    }
}

