/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.SecurityRealm;

public class DistributedRealm
implements SecurityRealm {
    private final PathAddress address;
    private final String name;
    private final String[] realms;

    DistributedRealm(String name, String[] realms) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"distributed-realm", (String)name)});
        this.realms = realms;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModelNode getAddOperation() {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        if (this.realms != null) {
            ModelNode realmsList = addOperation.get("realms");
            for (String realmName : this.realms) {
                realmsList.add(realmName);
            }
        }
        return addOperation;
    }

    public ModelNode getRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)this.address);
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getAddOperation(), client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getRemoveOperation(), client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String[] realms;

        Builder(String name) {
            this.name = name;
        }

        public Builder withRealms(String ... realms) {
            this.realms = realms;
            return this;
        }

        public SecurityRealm build() {
            return new DistributedRealm(this.name, this.realms);
        }
    }
}

