/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Supplier;
import org.junit.Assume;

public class AssumeTestGroupUtil {
    public static void assumeElytronProfileEnabled() {
        AssumeTestGroupUtil.assumeCondition("Tests failing in Elytron profile are disabled", () -> System.getProperty("elytron") == null);
    }

    public static void assumeSecurityManagerDisabled() {
        AssumeTestGroupUtil.assumeCondition("Tests failing if the security manager is enabled.", () -> System.getProperty("security.manager") == null);
    }

    public static void assumeJDKVersionAfter(int javaSpecificationVersion) {
        assert (javaSpecificationVersion >= 8);
        AssumeTestGroupUtil.assumeCondition("Tests failing if the JDK in use is before " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.getJavaSpecificationVersion() > javaSpecificationVersion);
    }

    public static void assumeJDKVersionBefore(int javaSpecificationVersion) {
        assert (javaSpecificationVersion >= 9);
        AssumeTestGroupUtil.assumeCondition("Tests failing if the JDK in use is after " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.getJavaSpecificationVersion() < javaSpecificationVersion);
    }

    private static int getJavaSpecificationVersion() {
        String versionString = System.getProperty("java.specification.version");
        versionString = versionString.startsWith("1.") ? versionString.substring(2) : versionString;
        return Integer.parseInt(versionString);
    }

    private static void assumeCondition(final String message, final Supplier<Boolean> assumeTrueCondition) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Assume.assumeTrue((String)message, (boolean)((Boolean)assumeTrueCondition.get()));
                return null;
            }
        });
    }
}

