/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.Resource;

public class ResourceListingUtils {
    private static final Logger log = Logger.getLogger(ResourceListingUtils.class);

    public static List<String> listResources(ModuleClassLoader classLoader, String rootDir, boolean recursive) {
        ArrayList<String> resourceList = new ArrayList<String>();
        Iterator it = classLoader.iterateResources(rootDir, recursive);
        while (it.hasNext()) {
            resourceList.add(((Resource)it.next()).getName());
        }
        return resourceList;
    }

    public static String classToPath(Class clazz) {
        return clazz.getName().replaceAll("\\.", "/") + ".class";
    }

    public static void filterResources(Collection<String> resources, String rootDir, boolean removeRecursive) {
        String rootDirPrefix = "";
        if (rootDir.startsWith("/")) {
            rootDirPrefix = rootDir.substring(1);
        }
        Iterator<String> it = resources.iterator();
        while (it.hasNext()) {
            String resource = it.next();
            if (resource.startsWith(rootDirPrefix)) {
                if (!removeRecursive) continue;
                String resourceWithoutPrefix = resource.substring(rootDirPrefix.length());
                if (resourceWithoutPrefix.startsWith("/")) {
                    resourceWithoutPrefix = resourceWithoutPrefix.substring(1);
                }
                log.trace((Object)("Original resource to check = " + resource));
                log.trace((Object)("Resource without its rootDir = " + resourceWithoutPrefix));
                if (!resourceWithoutPrefix.contains("/")) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
    }
}

