/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;

class XidsPersister {
    private static final Logger log = Logger.getLogger(XidsPersister.class);
    private String fileToPersit;

    XidsPersister(String fileToPersit) {
        this.fileToPersit = fileToPersit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void writeToDisk(Collection<Xid> xidsToSave) {
        Path logFile = this.getLogFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(logFile.toFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(xidsToSave);
            log.debugf("Xids %s were written as the new state of the file %s", xidsToSave, (Object)logFile);
        }
        catch (IOException ioe) {
            log.errorf((Throwable)ioe, "Cannot write xids %s to persistent file %s", xidsToSave, (Object)logFile);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {
                log.debugf((Throwable)ioe, "Cannot close FileOutputStream for file %s", (Object)logFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Collection<Xid> recoverFromDisk() {
        Path logFile = this.getLogFile();
        if (!logFile.toFile().exists()) {
            log.debugf("There is no file %s with recovery data for the test XAResource, no data for recovery", (Object)logFile);
            return new ArrayList<Xid>();
        }
        log.debugf("There is found file %s for transaction recovery of the test XAResource", (Object)logFile);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(logFile.toFile());
            ObjectInputStream ois = new ObjectInputStream(fis);
            Collection xids = (Collection)ois.readObject();
            log.infof("Number of xids for recovery is %d.%nContent: %s", (Object)xids.size(), (Object)xids);
            Collection collection = xids;
            return collection;
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Cannot load recovery data for test XAResource from file %s", (Object)logFile);
            ArrayList<Xid> arrayList = new ArrayList<Xid>();
            return arrayList;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {
                log.debugf((Throwable)ioe, "Cannot close FileInputStrem for file %s", (Object)logFile);
            }
        }
    }

    private Path getLogFile() {
        try {
            File dataDir = new File(System.getProperty("jboss.server.data.dir"));
            dataDir.mkdirs();
            return dataDir.toPath().resolve(this.fileToPersit);
        }
        catch (InvalidPathException e) {
            throw new IllegalStateException("Cannot resolve path of recovery file " + this.fileToPersit + " for storing test XAResource data persistently");
        }
    }
}

