/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.as.test.shared.CliUtils;
import org.jboss.logging.Logger;
import org.wildfly.test.security.common.elytron.AbstractUserAttributeValuesCapableElement;
import org.wildfly.test.security.common.elytron.SecurityRealm;
import org.wildfly.test.security.common.elytron.UserWithAttributeValues;

public class PropertiesRealm
extends AbstractUserAttributeValuesCapableElement
implements SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(PropertiesRealm.class);
    private final String groupsAttribute;
    private final boolean plainText;
    private File tempFolder;

    private PropertiesRealm(Builder builder) {
        super(builder);
        this.groupsAttribute = builder.groupsAttribute;
        this.plainText = builder.plainText;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        this.tempFolder = Utils.createTemporaryFolder("ely-" + this.name);
        Properties usersProperties = new Properties();
        Properties rolesProperties = new Properties();
        for (UserWithAttributeValues user : this.getUsersWithAttributeValues()) {
            usersProperties.setProperty(user.getName(), user.getPassword());
            rolesProperties.setProperty(user.getName(), String.join((CharSequence)",", user.getValues()));
        }
        File usersFile = this.writeProperties(usersProperties, "users.properties");
        File rolesFile = this.writeProperties(rolesProperties, "roles.properties");
        String groupsAttrStr = this.groupsAttribute == null ? "" : String.format(", groups-attribute=\"%s\"", this.groupsAttribute);
        cli.sendLine(String.format("/subsystem=elytron/properties-realm=%s:add(users-properties={path=\"%s\", plain-text=%b}, groups-properties={path=\"%s\"}%s)", this.name, CliUtils.asAbsolutePath(usersFile), this.plainText, CliUtils.asAbsolutePath(rolesFile), groupsAttrStr));
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/properties-realm=%s:remove()", this.name));
        FileUtils.deleteQuietly((File)this.tempFolder);
        this.tempFolder = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    private File writeProperties(Properties properties, String fileName) throws IOException {
        File result = new File(this.tempFolder, fileName);
        LOGGER.debugv("Creating property file {0}", (Object)result);
        try (FileOutputStream fos = new FileOutputStream(result);){
            if (this.plainText) {
                properties.store(fos, null);
            } else {
                properties.store(fos, "$REALM_NAME=" + this.name + "$");
            }
        }
        return result;
    }

    public static final class Builder
    extends AbstractUserAttributeValuesCapableElement.Builder<Builder> {
        private String groupsAttribute;
        private boolean plainText = true;

        private Builder() {
        }

        public Builder withGroupsAttribute(String groupsAttribute) {
            this.groupsAttribute = groupsAttribute;
            return this;
        }

        public Builder withPlainText(boolean plainText) {
            this.plainText = plainText;
            return this;
        }

        public PropertiesRealm build() {
            return new PropertiesRealm(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

