/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.Utils;

public class ServletElytronDomainSetup
implements ServerSetupTask {
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "elytron-tests";
    private PathAddress httpAuthenticationAddress;
    private PathAddress undertowDomainAddress;
    private final String securityDomainName;
    private final boolean useAuthenticationFactory;

    public ServletElytronDomainSetup() {
        this(DEFAULT_SECURITY_DOMAIN_NAME);
    }

    public ServletElytronDomainSetup(String securityDomainName) {
        this(securityDomainName, true);
    }

    public ServletElytronDomainSetup(String securityDomainName, boolean useAuthenticationFactory) {
        this.securityDomainName = securityDomainName;
        this.useAuthenticationFactory = useAuthenticationFactory;
    }

    protected String getSecurityDomainName() {
        return this.securityDomainName;
    }

    protected String getUndertowDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getHttpAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getDeploymentSecurityDomain() {
        return this.getSecurityDomainName();
    }

    protected boolean useAuthenticationFactory() {
        return this.useAuthenticationFactory;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.httpAuthenticationAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("http-authentication-factory", this.getHttpAuthenticationName());
        this.undertowDomainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "undertow").append("application-security-domain", this.getUndertowDomainName());
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        if (this.useAuthenticationFactory()) {
            ModelNode addHttpAuthentication = Util.createAddOperation((PathAddress)this.httpAuthenticationAddress);
            addHttpAuthentication.get("security-domain").set(this.getSecurityDomainName());
            addHttpAuthentication.get("http-server-mechanism-factory").set("global");
            addHttpAuthentication.get("mechanism-configurations").get(0).get("mechanism-name").set("BASIC");
            addHttpAuthentication.get("mechanism-configurations").get(0).get("mechanism-realm-configurations").get(0).get("realm-name").set("TestingRealm");
            steps.add(addHttpAuthentication);
        }
        ModelNode addUndertowDomain = Util.createAddOperation((PathAddress)this.undertowDomainAddress);
        if (this.useAuthenticationFactory()) {
            addUndertowDomain.get("http-authentication-factory").set(this.getHttpAuthenticationName());
        } else {
            addUndertowDomain.get("security-domain").set(this.getSecurityDomainName());
        }
        steps.add(addUndertowDomain);
        Utils.applyUpdate(managementClient.getControllerClient(), compositeOp, false);
    }

    public void tearDown(ManagementClient managementClient, String containerId) {
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.undertowDomainAddress, false);
        if (this.useAuthenticationFactory()) {
            Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.httpAuthenticationAddress, false);
        }
    }
}

