/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Attributes;

@WebServlet(urlPatterns={"/printAttributes"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"*"}))
public class AttributePrintingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/printAttributes";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        SecurityIdentity securityIdentity = securityDomain.getCurrentSecurityIdentity();
        Attributes attributes = securityIdentity.getAttributes();
        for (Attributes.Entry currentAttribute : attributes.entries()) {
            writer.print(currentAttribute.getKey());
            writer.print("=");
            for (int i = 0; i < currentAttribute.size(); ++i) {
                writer.print((String)currentAttribute.get(i));
                if (i >= currentAttribute.size()) continue;
                writer.print(",");
            }
            writer.println();
        }
        writer.close();
    }
}

