/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.undertow.common.elytron;

import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.undertow.common.elytron.HttpsListener;

public class SimpleHttpsListener
extends AbstractConfigurableElement
implements HttpsListener {
    private final String socketBinding;
    private final String sslContext;
    private final String securityRealm;

    private SimpleHttpsListener(Builder builder) {
        super(builder);
        this.socketBinding = builder.socketBinding;
        this.sslContext = builder.sslContext;
        this.securityRealm = builder.securityRealm;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        if (this.sslContext != null) {
            cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:add(socket-binding=%s,ssl-context=%s)", this.name, this.socketBinding, this.sslContext));
        } else {
            cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:add(socket-binding=%s,security-realm=%s)", this.name, this.socketBinding, this.securityRealm));
        }
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String socketBinding;
        private String sslContext;
        private String securityRealm;

        private Builder() {
        }

        public Builder withSocketBinding(String socketBinding) {
            this.socketBinding = socketBinding;
            return this;
        }

        public Builder withSslContext(String sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withSecurityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
            return this;
        }

        public SimpleHttpsListener build() {
            if (this.socketBinding == null) {
                throw new RuntimeException("socket-binding is required when creating https-listener");
            }
            if (this.sslContext == null && this.securityRealm == null || this.sslContext != null && this.securityRealm != null) {
                throw new RuntimeException("exactly one of ssl-context and security-realm must be defined when creating https-listener");
            }
            return new SimpleHttpsListener(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

