/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.stabilitylevel;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.ManagementOperations;
import org.jboss.as.test.integration.management.util.ServerReload;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Assume;

public abstract class StabilityServerSetupSnapshotRestoreTasks
implements ServerSetupTask {
    private final Stability desiredStability;
    private volatile Stability originalStability;
    private AutoCloseable snapshot;

    public StabilityServerSetupSnapshotRestoreTasks(Stability desiredStability) {
        this.desiredStability = desiredStability;
    }

    public final void setup(ManagementClient managementClient, String containerId) throws Exception {
        Set<Stability> supportedStabilityLevels = this.getSupportedStabilityLevels(managementClient);
        Assume.assumeTrue((String)String.format("%s is not a supported stability level. Supported levels: %s", this.desiredStability, supportedStabilityLevels), (boolean)supportedStabilityLevels.contains(this.desiredStability));
        Assume.assumeTrue((String)"The reload-enhanced operation is not registered at this stability level", (boolean)this.checkReloadEnhancedOperationIsAvailable(managementClient));
        Stability reloadOpStability = this.getReloadEnhancedOperationStabilityLevel(managementClient);
        Assume.assumeTrue((boolean)this.desiredStability.enables(reloadOpStability));
        this.originalStability = this.readCurrentStability(managementClient.getControllerClient());
        Assume.assumeTrue((boolean)this.desiredStability.enables(this.originalStability));
        this.snapshot = StabilityServerSetupSnapshotRestoreTasks.takeSnapshot(managementClient, this.originalStability);
        this.reloadToDesiredStability(managementClient.getControllerClient(), this.desiredStability);
        this.doSetup(managementClient);
    }

    protected void doSetup(ManagementClient managementClient) throws Exception {
    }

    public final void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.tearDown(managementClient);
        this.snapshot.close();
    }

    public final void tearDown(ManagementClient managementClient) throws Exception {
    }

    private boolean checkReloadEnhancedOperationIsAvailable(ManagementClient managementClient) throws Exception {
        ModelNode op = Util.createOperation((String)"read-operation-names", (PathAddress)PathAddress.EMPTY_ADDRESS);
        ModelNode result = ManagementOperations.executeOperation((ModelControllerClient)managementClient.getControllerClient(), (ModelNode)op);
        for (ModelNode name : result.asList()) {
            if (!name.asString().equals("reload-enhanced")) continue;
            return true;
        }
        return false;
    }

    private Stability getReloadEnhancedOperationStabilityLevel(ManagementClient managementClient) throws Exception {
        ModelNode op = Util.createOperation((String)"read-operation-description", (PathAddress)PathAddress.EMPTY_ADDRESS);
        op.get("name").set("reload-enhanced");
        ModelNode result = ManagementOperations.executeOperation((ModelControllerClient)managementClient.getControllerClient(), (ModelNode)op);
        String stability = result.get("stability").asString();
        return Stability.fromString((String)stability);
    }

    private Set<Stability> getSupportedStabilityLevels(ManagementClient managementClient) throws Exception {
        ModelNode op = Util.getReadAttributeOperation((PathAddress)PathAddress.pathAddress((String)"core-service", (String)"server-environment"), (String)"permissible-stability-levels");
        ModelNode result = ManagementOperations.executeOperation((ModelControllerClient)managementClient.getControllerClient(), (ModelNode)op);
        HashSet<Stability> set = new HashSet<Stability>();
        for (ModelNode mn : result.asList()) {
            set.add(Stability.fromString((String)mn.asString()));
        }
        return set;
    }

    private Stability reloadToDesiredStability(ModelControllerClient client, Stability stability) throws Exception {
        Stability currentStability = this.readCurrentStability(client);
        if (currentStability == stability) {
            return this.originalStability;
        }
        ServerReload.Parameters parameters = new ServerReload.Parameters().setStability(stability);
        ServerReload.executeReloadAndWaitForCompletion((ModelControllerClient)client, (ServerReload.Parameters)parameters);
        Stability reloadedStability = this.readCurrentStability(client);
        Assert.assertEquals((Object)stability, (Object)reloadedStability);
        return this.originalStability;
    }

    private Stability readCurrentStability(ModelControllerClient client) throws Exception {
        ModelNode op = Util.getReadAttributeOperation((PathAddress)PathAddress.pathAddress((String)"core-service", (String)"server-environment"), (String)"stability");
        ModelNode result = ManagementOperations.executeOperation((ModelControllerClient)client, (ModelNode)op);
        return Stability.fromString((String)result.asString());
    }

    private static AutoCloseable takeSnapshot(final ManagementClient client, final Stability reloadToStability) {
        try {
            String snapshot;
            ModelNode node = new ModelNode();
            node.get("operation").set("take-snapshot");
            ModelNode result = client.getControllerClient().execute(node);
            if (!"success".equals(result.get("outcome").asString())) {
                Assert.fail((String)("take-snapshot operation didn't finish successfully: " + result.asString()));
            }
            final String fileName = (snapshot = result.get("result").asString()).contains(File.separator) ? snapshot.substring(snapshot.lastIndexOf(File.separator) + 1) : snapshot;
            return new AutoCloseable(){

                @Override
                public void close() throws Exception {
                    ServerReload.Parameters parameters = new ServerReload.Parameters();
                    parameters.setServerConfig(fileName);
                    if (reloadToStability != null) {
                        parameters.setStability(reloadToStability);
                    }
                    ServerReload.executeReloadAndWaitForCompletion((ModelControllerClient)client.getControllerClient(), (ServerReload.Parameters)parameters);
                    ModelNode node = new ModelNode();
                    node.get("operation").set("write-config");
                    ModelNode result = client.getControllerClient().execute(node);
                    if (!"success".equals(result.get("outcome").asString())) {
                        Assert.fail((String)("Failed to write config after restoring from snapshot " + result.asString()));
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to take snapshot", e);
        }
    }

    public static class Experimental
    extends StabilityServerSetupSnapshotRestoreTasks {
        public Experimental() {
            super(Stability.EXPERIMENTAL);
        }
    }

    public static class Preview
    extends StabilityServerSetupSnapshotRestoreTasks {
        public Preview() {
            super(Stability.PREVIEW);
        }
    }

    public static class Community
    extends StabilityServerSetupSnapshotRestoreTasks {
        public Community() {
            super(Stability.COMMUNITY);
        }
    }

    public static class Default
    extends StabilityServerSetupSnapshotRestoreTasks {
        public Default() {
            super(Stability.DEFAULT);
        }
    }
}

