/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.testcontainers.DockerClientFactory;

public class AssumeTestGroupUtil {
    private static final Logger logger = Logger.getLogger(AssumeTestGroupUtil.class);
    private static JavaArchive EMPTY_JAR;
    private static WebArchive EMPTY_WAR;
    private static EnterpriseArchive EMPTY_EAR;

    public static JavaArchive emptyJar() {
        if (EMPTY_JAR == null) {
            EMPTY_JAR = AssumeTestGroupUtil.emptyJar("empty");
        }
        return EMPTY_JAR;
    }

    public static JavaArchive emptyJar(String name) {
        Object jarName = name.endsWith(".jar") ? name : name + ".jar";
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)jarName)).addManifest();
    }

    public static WebArchive emptyWar() {
        if (EMPTY_WAR == null) {
            EMPTY_WAR = AssumeTestGroupUtil.emptyWar("empty");
        }
        return EMPTY_WAR;
    }

    public static WebArchive emptyWar(String name) {
        Object warName = name.endsWith(".war") ? name : name + ".war";
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)warName)).addManifest();
    }

    public static EnterpriseArchive emptyEar() {
        if (EMPTY_EAR == null) {
            EMPTY_EAR = AssumeTestGroupUtil.emptyEar("empty");
        }
        return EMPTY_EAR;
    }

    public static EnterpriseArchive emptyEar(String name) {
        Object earName = name.endsWith(".ear") ? name : name + ".ear";
        return (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)earName)).addManifest();
    }

    public static void assumeSecurityManagerDisabled() {
        AssumeTestGroupUtil.assumeCondition("Tests failing if the security manager is enabled.", AssumeTestGroupUtil::isSecurityManagerDisabled);
    }

    public static boolean isSecurityManagerEnabled() {
        return !AssumeTestGroupUtil.isSecurityManagerDisabled();
    }

    public static boolean isSecurityManagerDisabled() {
        return System.getProperty("security.manager") == null;
    }

    public static void assumeSecurityManagerDisabledOrAssumeJDKVersionBefore(int javaSpecificationVersion) {
        AssumeTestGroupUtil.assumeCondition("Tests failing if the security manager is enabled and JDK in use is after " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.isSecurityManagerDisabled() || AssumeTestGroupUtil.isJDKVersionBefore(javaSpecificationVersion));
    }

    public static void assumeJDKVersionAfter(int javaSpecificationVersion) {
        assert (javaSpecificationVersion >= 11);
        AssumeTestGroupUtil.assumeCondition("Tests failing if the JDK in use is before " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.isJDKVersionAfter(javaSpecificationVersion));
    }

    public static void assumeJDKVersionBefore(int javaSpecificationVersion) {
        assert (javaSpecificationVersion > 11);
        AssumeTestGroupUtil.assumeCondition("Tests failing if the JDK in use is after " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.isJDKVersionBefore(javaSpecificationVersion));
    }

    public static boolean isJDKVersionAfter(int javaSpecificationVersion) {
        return AssumeTestGroupUtil.getJavaSpecificationVersion() > javaSpecificationVersion;
    }

    public static boolean isJDKVersionBefore(int javaSpecificationVersion) {
        return AssumeTestGroupUtil.getJavaSpecificationVersion() < javaSpecificationVersion;
    }

    public static void assumeFullDistribution() {
        AssumeTestGroupUtil.assumeCondition("Tests requiring full distribution are disabled", AssumeTestGroupUtil::isFullDistribution);
    }

    public static boolean isFullDistribution() {
        return System.getProperty("testsuite.default.build.project.prefix", "").equals("");
    }

    public static void assumeDockerAvailable() {
        try {
            AssumeTestGroupUtil.assumeCondition("Docker is not available.", AssumeTestGroupUtil::isDockerAvailable);
        }
        catch (AssumptionViolatedException ex) {
            if (System.getProperty("org.wildfly.test.require.docker") != null && System.getProperty("org.wildfly.test.require.docker").equals("true")) {
                throw new RuntimeException("Docker is required but it is not available or is not properly configured");
            }
            throw ex;
        }
    }

    public static boolean isDockerAvailable() {
        try {
            DockerClientFactory.instance().client();
            return true;
        }
        catch (Throwable ex) {
            logger.error((Object)"Could not initialize docker", ex);
            return false;
        }
    }

    public static void assumeNotWildFlyPreview() {
        AssumeTestGroupUtil.assumeCondition("Some tests are disabled on WildFly Preview", () -> !AssumeTestGroupUtil.isWildFlyPreview());
    }

    public static void assumeWildFlyPreview() {
        AssumeTestGroupUtil.assumeCondition("Some tests require WildFly Preview", AssumeTestGroupUtil::isWildFlyPreview);
    }

    public static boolean isWildFlyPreview() {
        return System.getProperty("ts.preview") != null || System.getProperty("ts.bootable.preview") != null;
    }

    public static void assumeBootableJar() {
        AssumeTestGroupUtil.assumeCondition("Some tests require bootable jar packaging", AssumeTestGroupUtil::isBootableJar);
    }

    public static boolean isBootableJar() {
        return System.getProperty("ts.bootable") != null || System.getProperty("ts.bootable.preview") != null;
    }

    private static int getJavaSpecificationVersion() {
        String versionString = System.getProperty("java.specification.version");
        return Integer.parseInt(versionString);
    }

    private static void assumeCondition(final String message, final Supplier<Boolean> assumeTrueCondition) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Assume.assumeTrue((String)message, (boolean)((Boolean)assumeTrueCondition.get()));
                return null;
            }
        });
    }
}

