/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class X500AttributePrincipalDecoder
extends AbstractConfigurableElement {
    private final String oid;
    private final String attributeName;
    private final Integer maximumSegments;

    private X500AttributePrincipalDecoder(Builder builder) {
        super(builder);
        this.oid = builder.oid;
        this.attributeName = builder.attributeName;
        this.maximumSegments = builder.maximumSegments;
        if (this.attributeName == null && this.oid == null || this.attributeName != null && this.oid != null) {
            throw new IllegalArgumentException("attribute-name xor oid has to be provided");
        }
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder command = new StringBuilder("/subsystem=elytron/x500-attribute-principal-decoder=").append(this.name).append(":add(");
        if (this.oid != null) {
            command.append("oid=").append(this.oid);
        } else {
            command.append("attribute-name=").append(this.attributeName);
        }
        if (this.maximumSegments != null) {
            command.append(",maximum-segments=").append(this.maximumSegments);
        }
        command.append(")");
        cli.sendLine(command.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/x500-attribute-principal-decoder=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String oid;
        private String attributeName;
        private Integer maximumSegments;

        private Builder() {
        }

        public Builder withOid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder withAttributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder withMaximumSegments(int maximumSegments) {
            this.maximumSegments = maximumSegments;
            return this;
        }

        public X500AttributePrincipalDecoder build() {
            return new X500AttributePrincipalDecoder(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

