/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.test.integration.domain.management.util.DomainControllerClientConfig;
import org.jboss.as.test.integration.domain.management.util.DomainTestClient;
import org.jboss.as.test.integration.domain.management.util.DomainTestConnection;
import org.jboss.as.test.integration.domain.management.util.JBossAsManagedConfiguration;
import org.jboss.as.test.integration.domain.management.util.ProcessWrapper;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.xnio.IoUtils;

public class DomainLifecycleUtil {
    public static final String SLAVE_HOST_PASSWORD = "slave_us3r_password";
    private static final ThreadFactory threadFactory = new AsyncThreadFactory();
    private final Logger log = Logger.getLogger(DomainLifecycleUtil.class.getName());
    private ProcessWrapper process;
    private DomainTestConnection connection;
    private DomainTestClient domainClient;
    private Map<ServerIdentity, ControlledProcessState.State> serverStatuses = new HashMap<ServerIdentity, ControlledProcessState.State>();
    private ExecutorService executor;
    private final JBossAsManagedConfiguration configuration;
    private final DomainControllerClientConfig clientConfiguration;
    private final PathAddress address;

    public DomainLifecycleUtil(JBossAsManagedConfiguration configuration) throws IOException {
        this(configuration, DomainControllerClientConfig.create());
    }

    public DomainLifecycleUtil(JBossAsManagedConfiguration configuration, DomainControllerClientConfig clientConfiguration) {
        assert (configuration != null) : "configuration is null";
        assert (clientConfiguration != null) : "clientConfiguration is null";
        this.configuration = configuration;
        this.clientConfiguration = clientConfiguration;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)configuration.getHostName())});
    }

    public JBossAsManagedConfiguration getConfiguration() {
        return this.configuration;
    }

    public PathAddress getAddress() {
        return this.address;
    }

    public void start() {
        try {
            String name;
            String domainDirectory;
            File modulesJar;
            this.configuration.validate();
            String address = NetworkUtils.formatPossibleIpv6Address((String)this.configuration.getHostControllerManagementAddress());
            int port = this.configuration.getHostControllerManagementPort();
            URI connectionURI = new URI("remote://" + address + ":" + port);
            this.connection = this.clientConfiguration.createConnection(connectionURI, this.configuration.getCallbackHandler());
            String jbossHomeDir = this.configuration.getJbossHome();
            ArrayList additionalJavaOpts = new ArrayList();
            String jbossOptions = System.getProperty("jboss.options");
            if (jbossOptions != null) {
                Collections.addAll(additionalJavaOpts, jbossOptions.split("\\s+"));
            }
            if (this.configuration.getJavaVmArguments() != null) {
                Collections.addAll(additionalJavaOpts, this.configuration.getJavaVmArguments().split("\\s+"));
            }
            if (!(modulesJar = new File(jbossHomeDir + File.separatorChar + "jboss-modules.jar")).exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            String javaHome = this.configuration.getJavaHome();
            String java = javaHome != null ? javaHome + File.separatorChar + "bin" + File.separatorChar + "java" : "java";
            String controllerJavaHome = this.configuration.getControllerJavaHome();
            String controllerJava = controllerJavaHome != null ? controllerJavaHome + File.separatorChar + "bin" + File.separatorChar + "java" : "java";
            File domainDir = this.configuration.getDomainDirectory() != null ? new File(this.configuration.getDomainDirectory()) : new File(new File(jbossHomeDir), "domain");
            String domainPath = domainDir.getAbsolutePath();
            String modulePath = this.configuration.getModulePath() != null && !this.configuration.getModulePath().isEmpty() ? this.configuration.getModulePath() : jbossHomeDir + File.separatorChar + "modules";
            File usersFile = new File(domainPath + "/configuration/mgmt-users.properties");
            FileOutputStream fos = new FileOutputStream(usersFile);
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println("slave=" + new UsernamePasswordHashUtil().generateHashedHexURP("slave", "ManagementRealm", SLAVE_HOST_PASSWORD.toCharArray()));
            pw.close();
            fos.close();
            File appUsersProps = new File(domainPath + "/configuration/application-users.properties");
            fos = new FileOutputStream(appUsersProps);
            pw = new PrintWriter(fos, true);
            pw.println("# Application users");
            pw.close();
            fos.close();
            File appRolesProps = new File(domainPath + "/configuration/application-roles.properties");
            fos = new FileOutputStream(appRolesProps);
            pw = new PrintWriter(fos, true);
            pw.println("# Application roles");
            pw.close();
            fos.close();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(controllerJava);
            cmd.addAll(additionalJavaOpts);
            TestSuiteEnvironment.getIpv6Args(cmd);
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + domainPath + "/log/process-controller.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/domain/configuration/logging.properties");
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulePath);
            cmd.add("org.jboss.as.process-controller");
            cmd.add("-jboss-home");
            cmd.add(jbossHomeDir);
            cmd.add("-jvm");
            cmd.add(controllerJava);
            cmd.add("--");
            cmd.add("-Dorg.jboss.boot.log.file=" + domainPath + "/log/host-controller.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/domain/configuration/logging.properties");
            TestSuiteEnvironment.getIpv6Args(cmd);
            cmd.addAll(additionalJavaOpts);
            cmd.add("--");
            cmd.add("-default-jvm");
            cmd.add(java);
            if (this.configuration.getHostCommandLineProperties() != null) {
                Collections.addAll(cmd, this.configuration.getHostCommandLineProperties().split("\\s+"));
            }
            if (this.configuration.isAdminOnly()) {
                cmd.add("--admin-only");
            }
            if ((domainDirectory = this.configuration.getDomainDirectory()) != null) {
                cmd.add("-Djboss.domain.base.dir=" + domainDirectory);
            } else {
                domainDirectory = domainPath;
            }
            if (this.configuration.getDomainConfigFile() != null) {
                name = this.copyConfigFile(new File(this.configuration.getDomainConfigFile()), new File(domainDirectory, "configuration"));
                if (this.configuration.isReadOnlyDomain()) {
                    cmd.add("--read-only-domain-config=" + name);
                } else {
                    cmd.add("--domain-config=" + name);
                }
            }
            if (this.configuration.getHostConfigFile() != null) {
                name = this.copyConfigFile(new File(this.configuration.getHostConfigFile()), new File(domainDirectory, "configuration"));
                if (this.configuration.isReadOnlyHost()) {
                    cmd.add("--read-only-host-config=" + name);
                } else {
                    cmd.add("--host-config=" + name);
                }
            }
            if (this.configuration.getHostControllerManagementAddress() != null) {
                cmd.add("--interprocess-hc-address");
                cmd.add(this.configuration.getHostControllerManagementAddress());
                cmd.add("--pc-address");
                cmd.add(this.configuration.getHostControllerManagementAddress());
            }
            String workingDir = this.configuration.getDomainDirectory();
            ProcessWrapper wrapper = new ProcessWrapper(this.configuration.getHostName(), cmd, Collections.emptyMap(), workingDir);
            wrapper.start();
            this.process = wrapper;
            long start = System.currentTimeMillis();
            if (!this.configuration.isAdminOnly()) {
                TimeUnit.SECONDS.sleep(2L);
                this.awaitServers(start);
                this.log.info("All servers started in " + (System.currentTimeMillis() - start) + " ms");
            }
            this.awaitHostController(start);
            this.log.info("HostController started in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start container", e);
        }
    }

    public Future<Void> startAsync() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DomainLifecycleUtil.this.start();
                return null;
            }
        };
        return this.getExecutorService().submit(c);
    }

    public void stop() {
        try {
            if (this.process != null) {
                this.process.stop();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop container", e);
        }
        finally {
            this.closeConnection();
            ExecutorService exec = this.executor;
            if (exec != null) {
                exec.shutdownNow();
                this.executor = null;
            }
        }
    }

    public Future<Void> stopAsync() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DomainLifecycleUtil.this.stop();
                return null;
            }
        };
        return Executors.newSingleThreadExecutor(threadFactory).submit(c);
    }

    public ModelNode executeAwaitConnectionClosed(ModelNode operation) throws IOException {
        DomainTestClient client = this.internalGetOrCreateClient();
        Channel channel = client.getChannel();
        if (null == channel) {
            throw new IllegalStateException("Didn't get a remoting channel from the DomainTestClient.");
        }
        Connection ref = channel.getConnection();
        ModelNode result = new ModelNode();
        try {
            result = client.execute(operation);
            if (!"success".equals(result.get("outcome").asString())) {
                return result;
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                Throwable cause = e.getCause();
                if (!(cause instanceof ExecutionException)) {
                    throw (IOException)e;
                }
            }
            throw new RuntimeException(e);
        }
        try {
            if (channel != null) {
                channel.awaitClosed();
            }
            this.connection.awaitConnectionClosed(ref);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public void connect() throws IOException {
        this.connect(30L, TimeUnit.SECONDS);
    }

    public void connect(long timeout, TimeUnit timeUnit) throws IOException {
        DomainTestConnection connection = this.connection;
        if (connection == null) {
            throw new IllegalStateException();
        }
        long deadline = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        long remaining;
        while ((remaining = deadline - System.currentTimeMillis()) > 0L) {
            try {
                connection.connect();
                return;
            }
            catch (IOException e) {
                if ((remaining = deadline - System.currentTimeMillis()) > 0L) continue;
                throw e;
            }
            break;
        }
        return;
    }

    public DomainClient createDomainClient() {
        DomainTestConnection connection = this.connection;
        if (connection == null) {
            throw new IllegalStateException();
        }
        return DomainClient.Factory.create((ModelControllerClient)connection.createClient());
    }

    public synchronized DomainClient getDomainClient() {
        return DomainClient.Factory.create((ModelControllerClient)this.internalGetOrCreateClient());
    }

    public void awaitServers(long start) throws InterruptedException, TimeoutException {
        long remaining;
        boolean serversAvailable = false;
        long deadline = start + (long)(this.configuration.getStartupTimeoutInSeconds() * 1000);
        while (!serversAvailable && (remaining = deadline - System.currentTimeMillis()) > 0L) {
            TimeUnit.MILLISECONDS.sleep(250L);
            serversAvailable = this.areServersStarted();
        }
        if (!serversAvailable) {
            throw new TimeoutException(String.format("Managed servers were not started within [%d] seconds", this.configuration.getStartupTimeoutInSeconds()));
        }
    }

    private void awaitHostController(long start) throws InterruptedException, TimeoutException {
        long remaining;
        boolean hcAvailable = false;
        long deadline = start + (long)(this.configuration.getStartupTimeoutInSeconds() * 1000);
        while (!hcAvailable && (remaining = deadline - System.currentTimeMillis()) > 0L) {
            if (!hcAvailable) {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
            hcAvailable = this.isHostControllerStarted();
        }
        if (!hcAvailable) {
            throw new TimeoutException(String.format("HostController was not started within [%d] seconds", this.configuration.getStartupTimeoutInSeconds()));
        }
    }

    private synchronized DomainTestClient internalGetOrCreateClient() {
        if (this.domainClient == null) {
            try {
                this.domainClient = this.connection.createClient();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.domainClient;
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor(threadFactory);
        }
        return this.executor;
    }

    private boolean areServersStarted() {
        try {
            Map<ServerIdentity, ControlledProcessState.State> statuses = this.getServerStatuses();
            block5: for (Map.Entry<ServerIdentity, ControlledProcessState.State> entry : statuses.entrySet()) {
                switch (entry.getValue()) {
                    case RUNNING: {
                        continue block5;
                    }
                }
                this.log.log(Level.INFO, entry.getKey() + " status is " + entry.getValue());
                return false;
            }
            this.serverStatuses.putAll(statuses);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isHostControllerStarted() {
        try {
            ModelNode address = new ModelNode();
            address.add("host", this.configuration.getHostName());
            ControlledProcessState.State status = Enum.valueOf(ControlledProcessState.State.class, this.readAttribute("host-state", address).asString().toUpperCase(Locale.ENGLISH));
            return status == ControlledProcessState.State.RUNNING;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Caught exception closing DomainTestConnection", e);
            }
        }
    }

    private Map<ServerIdentity, ControlledProcessState.State> getServerStatuses() {
        HashMap<ServerIdentity, ControlledProcessState.State> result = new HashMap<ServerIdentity, ControlledProcessState.State>();
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("server-config");
        op.get("address").add("host", this.configuration.getHostName());
        ModelNode opResult = this.executeForResult(new OperationBuilder(op).build());
        HashSet<String> servers = new HashSet<String>();
        for (ModelNode modelNode : opResult.asList()) {
            servers.add(modelNode.asString());
        }
        for (String string : servers) {
            ModelNode address = new ModelNode();
            address.add("host", this.configuration.getHostName());
            address.add("server-config", string);
            String group = this.readAttribute("group", address).resolve().asString();
            if (!this.readAttribute("auto-start", address).resolve().asBoolean()) continue;
            address = new ModelNode();
            address.add("host", this.configuration.getHostName());
            address.add("server", string);
            ControlledProcessState.State status = Enum.valueOf(ControlledProcessState.State.class, this.readAttribute("server-state", address).asString().toUpperCase(Locale.ENGLISH));
            ServerIdentity id = new ServerIdentity(this.configuration.getHostName(), group, string);
            result.put(id, status);
        }
        return result;
    }

    private ModelNode readAttribute(String name, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address);
        op.get("name").set(name);
        return this.executeForResult(new OperationBuilder(op).build());
    }

    public ModelNode executeForResult(ModelNode op) {
        return this.executeForResult(new OperationBuilder(op).build());
    }

    public ModelNode executeForResult(Operation op) {
        try {
            ModelNode result = this.getDomainClient().execute(op);
            if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
                return result.get("result");
            }
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            if (result.hasDefined("domain-failure-description")) {
                throw new RuntimeException(result.get("domain-failure-description").toString());
            }
            if (result.hasDefined("host-failure-descriptions")) {
                throw new RuntimeException(result.get("host-failure-descriptions").toString());
            }
            throw new RuntimeException("Operation outcome is " + result.get("outcome").asString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyConfigFile(File file, File dir) {
        File newFile = new File(dir, "testing-" + file.getName());
        if (newFile.exists()) {
            newFile.delete();
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
                try {
                    int i = ((InputStream)in).read();
                    while (i != -1) {
                        ((OutputStream)out).write(i);
                        i = ((InputStream)in).read();
                    }
                }
                finally {
                    IoUtils.safeClose((Closeable)out);
                }
            }
            finally {
                IoUtils.safeClose((Closeable)in);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newFile.getName();
    }

    private static final class AsyncThreadFactory
    implements ThreadFactory {
        private int threadCount;

        private AsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, DomainLifecycleUtil.class.getSimpleName() + "-" + ++this.threadCount);
            t.setDaemon(true);
            return t;
        }
    }
}

