/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class Authentication {
    public static CallbackHandler getCallbackHandler() {
        return new CallbackHandlerImpl("", "", null);
    }

    public static CallbackHandler getCallbackHandler(String username, String password, String realm) {
        return new CallbackHandlerImpl(username, password, realm);
    }

    private static class CallbackHandlerImpl
    implements CallbackHandler {
        private final String username;
        private final String password;
        private final String realm;

        private CallbackHandlerImpl(String username, String password, String realm) {
            this.username = username;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password.toCharArray());
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    rcb.setText(this.realm != null ? this.realm : rcb.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

