/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class UndertowDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JSTL = ModuleIdentifier.create((String)"javax.servlet.jstl.api");
    private static final ModuleIdentifier UNDERTOW_CORE = ModuleIdentifier.create((String)"io.undertow.core");
    private static final ModuleIdentifier UNDERTOW_SERVLET = ModuleIdentifier.create((String)"io.undertow.servlet");
    private static final ModuleIdentifier UNDERTOW_JSP = ModuleIdentifier.create((String)"io.undertow.jsp");
    private static final ModuleIdentifier UNDERTOW_WEBSOCKET = ModuleIdentifier.create((String)"io.undertow.websocket");
    private static final ModuleIdentifier UNDERTOW_JS = ModuleIdentifier.create((String)"io.undertow.js");
    private static final ModuleIdentifier CLUSTERING_API = ModuleIdentifier.create((String)"org.wildfly.clustering.web.api");
    private static final ModuleIdentifier SERVLET_API = ModuleIdentifier.create((String)"javax.servlet.api");
    private static final ModuleIdentifier JSP_API = ModuleIdentifier.create((String)"javax.servlet.jsp.api");
    private static final ModuleIdentifier WEBSOCKET_API = ModuleIdentifier.create((String)"javax.websocket.api");

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SERVLET_API, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSP_API, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, WEBSOCKET_API, false, false, true, false));
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSTL, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, UNDERTOW_CORE, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, UNDERTOW_SERVLET, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, UNDERTOW_JSP, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, UNDERTOW_WEBSOCKET, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, UNDERTOW_JS, true, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, CLUSTERING_API, true, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }

    static {
        Module module = Module.forClass(UndertowDependencyProcessor.class);
        if (module != null) {
            Module.registerURLStreamHandlerFactoryModule((Module)module);
        }
    }
}

