/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Sequence;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;

public class PersistKeyAssigner {
    private Catalog catalog;
    private Format keyFormat;
    private Format entityFormat;
    private boolean rawAccess;
    private Sequence sequence;

    PersistKeyAssigner(PersistKeyBinding keyBinding, PersistEntityBinding entityBinding, Sequence sequence) {
        this.catalog = keyBinding.catalog;
        this.keyFormat = keyBinding.keyFormat;
        this.entityFormat = entityBinding.entityFormat;
        this.rawAccess = entityBinding.rawAccess;
        this.sequence = sequence;
    }

    public boolean assignPrimaryKey(Object entity, DatabaseEntry key) throws DatabaseException {
        if (this.entityFormat.isPriKeyNullOrZero(entity, this.rawAccess)) {
            Long value = this.sequence.get(null, 1);
            EntityOutput output = new EntityOutput(this.catalog, this.rawAccess);
            this.keyFormat.writeObject(value, output, this.rawAccess);
            TupleBase.outputToEntry(output, key);
            EntityInput input = new EntityInput(this.catalog, this.rawAccess, null, 0, key.getData(), key.getOffset(), key.getSize());
            this.entityFormat.readPriKey(entity, input, this.rawAccess);
            return true;
        }
        return false;
    }
}

