/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import net.spy.memcached.CASMutation;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.transcoders.Transcoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASMutator<T>
extends SpyObject {
    private static final int MAX_TRIES = 8192;
    private final MemcachedClientIF client;
    private final Transcoder<T> transcoder;
    private final int max;

    public CASMutator(MemcachedClientIF c, Transcoder<T> tc, int max_tries) {
        this.client = c;
        this.transcoder = tc;
        this.max = max_tries;
    }

    public CASMutator(MemcachedClientIF c, Transcoder<T> tc) {
        this(c, tc, 8192);
    }

    public T cas(String key, T initial, int initialExp, CASMutation<T> m) throws Exception {
        T rv = initial;
        boolean done = false;
        for (int i = 0; !done && i < this.max; ++i) {
            CASValue<T> casval = this.client.gets(key, this.transcoder);
            Object current = null;
            if (casval != null) {
                T tmp = casval.getValue();
                current = tmp;
            }
            if (current != null) {
                assert (casval != null) : "casval was null with a current value";
                rv = m.getNewValue(current);
                if (this.client.cas(key, casval.getCas(), rv, this.transcoder) != CASResponse.OK) continue;
                done = true;
                continue;
            }
            if (initial == null) {
                done = true;
                rv = null;
                continue;
            }
            if (!this.client.add(key, initialExp, initial, this.transcoder).get().booleanValue()) continue;
            done = true;
            rv = initial;
        }
        if (!done) {
            throw new RuntimeException("Couldn't get a CAS in " + this.max + " attempts");
        }
        return rv;
    }
}

