/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import net.spy.memcached.compat.log.Level;
import net.spy.memcached.compat.log.Logger;

public abstract class AbstractLogger
implements Logger {
    private final String name;

    protected AbstractLogger(String nm) {
        if (nm == null) {
            throw new NullPointerException("Logger name may not be null.");
        }
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public Throwable getThrowable(Object[] args) {
        Throwable rv = null;
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            rv = (Throwable)args[args.length - 1];
        }
        return rv;
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public void debug(Object message, Throwable exception) {
        this.log(Level.DEBUG, message, exception);
    }

    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debug((Object)String.format(message, args), this.getThrowable(args));
        }
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void info(Object message, Throwable exception) {
        this.log(Level.INFO, message, exception);
    }

    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.info((Object)String.format(message, args), this.getThrowable(args));
        }
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void warn(Object message, Throwable exception) {
        this.log(Level.WARN, message, exception);
    }

    public void warn(String message, Object ... args) {
        this.warn((Object)String.format(message, args), this.getThrowable(args));
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void error(Object message, Throwable exception) {
        this.log(Level.ERROR, message, exception);
    }

    public void error(String message, Object ... args) {
        this.error((Object)String.format(message, args), this.getThrowable(args));
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void fatal(Object message, Throwable exception) {
        this.log(Level.FATAL, message, exception);
    }

    public void fatal(String message, Object ... args) {
        this.fatal((Object)String.format(message, args), this.getThrowable(args));
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void log(Level level, Object message) {
        this.log(level, message, null);
    }

    public abstract void log(Level var1, Object var2, Throwable var3);
}

