/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.VBucketAware;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MultiKeyOperationImpl
extends OperationImpl
implements VBucketAware,
KeyedOperation {
    protected final Map<String, Short> vbmap = new HashMap<String, Short>();

    protected MultiKeyOperationImpl(int c, int o, OperationCallback cb) {
        super(c, o, cb);
    }

    @Override
    public Collection<String> getKeys() {
        return this.vbmap.keySet();
    }

    @Override
    public Collection<MemcachedNode> getNotMyVbucketNodes() {
        return this.notMyVbucketNodes;
    }

    @Override
    public void addNotMyVbucketNode(MemcachedNode node) {
        this.notMyVbucketNodes.add(node);
    }

    @Override
    public void setNotMyVbucketNodes(Collection<MemcachedNode> nodes) {
        this.notMyVbucketNodes = nodes;
    }

    @Override
    public void setVBucket(String k, short vb) {
        assert (this.vbmap.containsKey(k)) : "Key " + k + " not contained in operation";
        this.vbmap.put(k, new Short(vb));
    }

    @Override
    public short getVBucket(String k) {
        assert (this.vbmap.containsKey(k)) : "Key " + k + " not contained in operation";
        return this.vbmap.get(k);
    }
}

