/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.VBucketAware;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SingleKeyOperationImpl
extends OperationImpl
implements VBucketAware,
KeyedOperation {
    protected final String key;

    protected SingleKeyOperationImpl(int c, int o, String k, OperationCallback cb) {
        super(c, o, cb);
        this.key = k;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<MemcachedNode> getNotMyVbucketNodes() {
        return this.notMyVbucketNodes;
    }

    @Override
    public void addNotMyVbucketNode(MemcachedNode node) {
        this.notMyVbucketNodes.add(node);
    }

    @Override
    public void setNotMyVbucketNodes(Collection<MemcachedNode> nodes) {
        this.notMyVbucketNodes = nodes;
    }

    @Override
    public void setVBucket(String k, short vb) {
        assert (k.equals(this.key)) : k + " doesn't match the key " + this.key + " for this operation";
        this.vbucket = vb;
    }

    @Override
    public short getVBucket(String k) {
        assert (k.equals(this.key)) : k + " doesn't match the key " + this.key + " for this operation";
        return this.vbucket;
    }
}

