/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import net.spy.memcached.tapmessage.BaseMessage;
import net.spy.memcached.tapmessage.TapFlag;
import net.spy.memcached.tapmessage.Util;

public class RequestMessage
extends BaseMessage {
    private static final int NUM_VBUCKETS = 1024;
    private static final int FLAGS_FIELD_LENGTH = 4;
    private static final int BACKFILL_DATE_FIELD_LENGTH = 8;
    private static final int VBUCKET_LIST_FIELD_LENGTH = 2;
    private byte[] name;
    private byte[] flags = new byte[0];
    private byte[] backfilldate;
    private byte[] vbucketlist;
    private byte[] value;

    public RequestMessage() {
        this.name = new byte[0];
        this.backfilldate = new byte[0];
        this.vbucketlist = new byte[0];
        this.value = new byte[0];
    }

    public void setFlags(TapFlag f) {
        if (this.flags.length != 4) {
            this.flags = new byte[4];
        }
        if (!f.hasFlag(this.getFlags())) {
            long curFlags = Util.fieldToValue(this.flags, 0, 4);
            Util.valueToFieldOffest(this.flags, 0, 4, curFlags + (long)f.flag);
            this.encode();
        }
    }

    public void setBackfill(long date) {
        this.backfilldate = new byte[8];
        Util.valueToFieldOffest(this.backfilldate, 0, 8, date);
        this.encode();
    }

    public int getFlags() {
        if (this.flags.length != 4) {
            return 0;
        }
        return (int)Util.fieldToValue(this.flags, 0, 4);
    }

    public void setVbucketlist(int[] vbs) {
        byte[] vblist = new byte[(vbs.length + 1) * 2];
        for (int i = 0; i < vbs.length + 1; ++i) {
            if (i == 0) {
                Util.valueToFieldOffest(vblist, 0, 2, vbs.length);
                continue;
            }
            if (vbs[i - 1] < 1024 && vbs[i - 1] >= 0) {
                Util.valueToFieldOffest(vblist, i * 2, 2, vbs[i - 1]);
                continue;
            }
            this.getLogger().error("vBucket ignored " + vbs[i - 1] + "is not a valid vBucket number");
        }
        this.vbucketlist = vblist;
        this.encode();
    }

    public void setName(String s) {
        long len = s.length();
        if (len >= (long)((int)Math.pow(256.0, 2.0))) {
            throw new IllegalArgumentException("Name too big");
        }
        this.name = s.getBytes();
        this.setKeylength(len);
        this.encode();
    }

    private void encode() {
        int i;
        byte[] buffer = new byte[24 + this.name.length + this.flags.length + this.vbucketlist.length + this.backfilldate.length + this.value.length];
        int totalbody = 0;
        int extralength = 0;
        for (i = 0; i < this.flags.length; ++i) {
            buffer[24 + totalbody] = this.flags[i];
            ++totalbody;
            ++extralength;
        }
        this.setExtralength(extralength);
        for (i = 0; i < this.name.length; ++i) {
            buffer[24 + totalbody] = this.name[i];
            ++totalbody;
        }
        if (TapFlag.BACKFILL.hasFlag(this.getFlags())) {
            for (i = 0; i < this.backfilldate.length; ++i) {
                buffer[24 + totalbody] = this.backfilldate[i];
                ++totalbody;
            }
        }
        if (TapFlag.LIST_VBUCKETS.hasFlag(this.getFlags())) {
            for (i = 0; i < this.vbucketlist.length; ++i) {
                buffer[24 + totalbody] = this.vbucketlist[i];
                ++totalbody;
            }
        }
        for (i = 0; i < this.value.length; ++i) {
            buffer[24 + totalbody] = this.value[i];
            ++totalbody;
        }
        this.setTotalbody(totalbody);
        for (i = 0; i < 24; ++i) {
            buffer[i] = this.mbytes[i];
        }
        this.mbytes = buffer;
    }
}

