/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import net.spy.memcached.tapmessage.BaseMessage;
import net.spy.memcached.tapmessage.Util;

public class ResponseMessage
extends BaseMessage {
    private static final int ENGINE_PRIVATE_OFFSET = 0;
    private static final int ENGINE_PRIVATE_FIELD_LENGTH = 2;
    private static final int FLAGS_OFFSET = 2;
    private static final int FLAGS_FIELD_LENGTH = 2;
    private static final int TTL_OFFSET = 3;
    private static final int TTL_FIELD_LENGTH = 1;
    private static final int RESERVED1_OFFSET = 4;
    private static final int RESERVED1_FIELD_LENGTH = 1;
    private static final int RESERVED2_OFFSET = 5;
    private static final int RESERVED2_FIELD_LENGTH = 1;
    private static final int RESERVED3_OFFSET = 6;
    private static final int RESERVED3_FIELD_LENGTH = 1;
    private static final int ITEM_FLAGS_OFFSET = 7;
    private static final int ITEM_FLAGS_FIELD_LENGTH = 4;
    private static final int ITEM_EXPIRY_OFFSET = 11;
    private static final int ITEM_EXPIRY_FIELD_LENGTH = 5;

    public ResponseMessage(byte[] buffer) {
        this.mbytes = buffer;
    }

    public long getEnginePrivate() {
        if (2 > this.getExtralength()) {
            return 0L;
        }
        int offset = 24;
        return Util.fieldToValue(this.mbytes, offset, 2);
    }

    public int getFlags() {
        if (4 > this.getExtralength()) {
            return 0;
        }
        int offset = 26;
        return (int)Util.fieldToValue(this.mbytes, offset, 2);
    }

    public int getTTL() {
        if (4 > this.getExtralength()) {
            return 0;
        }
        int offset = 27;
        return (int)Util.fieldToValue(this.mbytes, offset, 1);
    }

    public int getReserved1() {
        if (5 > this.getExtralength()) {
            return 0;
        }
        int offset = 28;
        return (int)Util.fieldToValue(this.mbytes, offset, 1);
    }

    public int getReserved2() {
        if (6 > this.getExtralength()) {
            return 0;
        }
        int offset = 29;
        return (int)Util.fieldToValue(this.mbytes, offset, 1);
    }

    public int getReserved3() {
        if (7 > this.getExtralength()) {
            return 0;
        }
        int offset = 30;
        return (int)Util.fieldToValue(this.mbytes, offset, 1);
    }

    public int getItemFlags() {
        if (11 > this.getExtralength()) {
            return 0;
        }
        int offset = 31;
        return (int)Util.fieldToValue(this.mbytes, offset, 4);
    }

    public long getItemExpiry() {
        if (16 > this.getExtralength()) {
            return 0L;
        }
        int offset = 35;
        return Util.fieldToValue(this.mbytes, offset, 5);
    }

    public String getKey() {
        if (this.getExtralength() >= this.getTotalbody()) {
            return new String();
        }
        int offset = 24 + this.getExtralength();
        return new String(this.mbytes, offset, this.getKeylength());
    }

    public byte[] getValue() {
        if (this.getExtralength() + this.getKeylength() >= this.getTotalbody()) {
            return new byte[0];
        }
        int offset = 24 + this.getExtralength() + this.getKeylength();
        int length = this.getTotalbody() - this.getKeylength() - this.getExtralength();
        byte[] value = new byte[length];
        System.arraycopy(this.mbytes, offset, value, 0, length);
        return value;
    }
}

