/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.vbucket.BucketMonitor;
import net.spy.memcached.vbucket.ConfigurationException;
import net.spy.memcached.vbucket.ConfigurationProvider;
import net.spy.memcached.vbucket.Reconfigurable;
import net.spy.memcached.vbucket.ReconfigurableObserver;
import net.spy.memcached.vbucket.config.Bucket;
import net.spy.memcached.vbucket.config.Config;
import net.spy.memcached.vbucket.config.ConfigurationParser;
import net.spy.memcached.vbucket.config.ConfigurationParserJSON;
import net.spy.memcached.vbucket.config.Pool;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationProviderHTTP
extends SpyObject
implements ConfigurationProvider {
    private static final String DEFAULT_POOL_NAME = "default";
    private static final String ANONYMOUS_AUTH_BUCKET = "default";
    public static final String CLIENT_SPEC_VER = "1.0";
    private List<URI> baseList;
    private String restUsr;
    private String restPwd;
    private URI loadedBaseUri;
    private Map<String, Bucket> buckets = new ConcurrentHashMap<String, Bucket>();
    private ConfigurationParser configurationParser = new ConfigurationParserJSON();
    private Map<String, BucketMonitor> monitors = new HashMap<String, BucketMonitor>();

    public ConfigurationProviderHTTP(List<URI> baseList) throws IOException {
        this(baseList, null, null);
    }

    public ConfigurationProviderHTTP(List<URI> baseList, String restUsr, String restPwd) throws IOException {
        this.baseList = baseList;
        this.restUsr = restUsr;
        this.restPwd = restPwd;
    }

    @Override
    public Bucket getBucketConfiguration(String bucketname) throws ConfigurationException {
        if (bucketname == null || bucketname.isEmpty()) {
            throw new IllegalArgumentException("Bucket name can not be blank.");
        }
        Bucket bucket = this.buckets.get(bucketname);
        if (bucket == null) {
            this.readPools(bucketname);
        }
        return this.buckets.get(bucketname);
    }

    private void readPools(String bucketToFind) throws ConfigurationException {
        for (URI baseUri : this.baseList) {
            try {
                URLConnection baseConnection = this.urlConnBuilder(null, baseUri);
                String base = this.readToString(baseConnection);
                if ("".equals(base)) {
                    this.getLogger().warn("Provided URI " + baseUri + " has an empty response... skipping");
                    continue;
                }
                Map<String, Pool> pools = this.configurationParser.parseBase(base);
                if (!pools.containsKey("default")) {
                    this.getLogger().warn("Provided URI " + baseUri + " has no default pool... skipping");
                    continue;
                }
                for (Pool pool : pools.values()) {
                    URLConnection poolConnection = this.urlConnBuilder(baseUri, pool.getUri());
                    String poolString = this.readToString(poolConnection);
                    this.configurationParser.loadPool(pool, poolString);
                    URLConnection poolBucketsConnection = this.urlConnBuilder(baseUri, pool.getBucketsUri());
                    String sBuckets = this.readToString(poolBucketsConnection);
                    Map<String, Bucket> bucketsForPool = this.configurationParser.parseBuckets(sBuckets);
                    pool.replaceBuckets(bucketsForPool);
                }
                boolean bucketFound = false;
                for (Pool pool : pools.values()) {
                    if (!pool.hasBucket(bucketToFind)) continue;
                    bucketFound = true;
                    break;
                }
                if (bucketFound) {
                    for (Pool pool : pools.values()) {
                        for (Map.Entry<String, Bucket> bucketEntry : pool.getROBuckets().entrySet()) {
                            this.buckets.put(bucketEntry.getKey(), bucketEntry.getValue());
                        }
                    }
                    this.loadedBaseUri = baseUri;
                    return;
                }
            }
            catch (ParseException e) {
                this.getLogger().warn((Object)("Provided URI " + baseUri + " has an unparsable response...skipping"), e);
            }
            catch (IOException e) {
                this.getLogger().warn((Object)("Connection problems with URI " + baseUri + " ...skipping"), e);
            }
            throw new ConfigurationException("Configuration for bucket " + bucketToFind + " was not found.");
        }
    }

    public List<InetSocketAddress> getServerList(String bucketname) throws ConfigurationException {
        Bucket bucket = this.getBucketConfiguration(bucketname);
        List<String> servers = bucket.getConfig().getServers();
        StringBuilder serversString = new StringBuilder();
        for (String server : servers) {
            serversString.append(server).append(' ');
        }
        return AddrUtil.getAddresses(serversString.toString());
    }

    @Override
    public void subscribe(String bucketName, Reconfigurable rec) throws ConfigurationException {
        Bucket bucket = this.getBucketConfiguration(bucketName);
        ReconfigurableObserver obs = new ReconfigurableObserver(rec);
        BucketMonitor monitor = this.monitors.get(bucketName);
        if (monitor == null) {
            URI streamingURI = bucket.getStreamingURI();
            monitor = new BucketMonitor(this.loadedBaseUri.resolve(streamingURI), bucketName, this.restUsr, this.restPwd, this.configurationParser);
            this.monitors.put(bucketName, monitor);
            monitor.addObserver(obs);
            monitor.startMonitor();
        } else {
            monitor.addObserver(obs);
        }
    }

    @Override
    public void unsubscribe(String vbucketName, Reconfigurable rec) {
        BucketMonitor monitor = this.monitors.get(vbucketName);
        if (monitor != null) {
            monitor.deleteObserver(new ReconfigurableObserver(rec));
        }
    }

    public Config getLatestConfig(String bucketname) throws ConfigurationException {
        Bucket bucket = this.getBucketConfiguration(bucketname);
        return bucket.getConfig();
    }

    @Override
    public String getAnonymousAuthBucket() {
        return "default";
    }

    @Override
    public void shutdown() {
        for (BucketMonitor monitor : this.monitors.values()) {
            monitor.shutdown();
        }
    }

    private URLConnection urlConnBuilder(URI base, URI resource) throws IOException {
        if (!resource.isAbsolute() && base != null) {
            resource = base.resolve(resource);
        }
        URL specURL = resource.toURL();
        URLConnection connection = specURL.openConnection();
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("user-agent", "spymemcached vbucket client");
        connection.setRequestProperty("X-memcachekv-Store-Client-Specification-Version", CLIENT_SPEC_VER);
        if (this.restUsr != null) {
            try {
                connection.setRequestProperty("Authorization", ConfigurationProviderHTTP.buildAuthHeader(this.restUsr, this.restPwd));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IOException("Could not encode specified credentials for HTTP request.", ex);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readToString(URLConnection connection) throws IOException {
        BufferedReader reader = null;
        try {
            String str;
            InputStream inStream = connection.getInputStream();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                if (httpConnection.getResponseCode() == 403) {
                    throw new IOException("Service does not accept the authentication credentials: " + httpConnection.getResponseCode() + httpConnection.getResponseMessage());
                }
                if (httpConnection.getResponseCode() >= 400) {
                    throw new IOException("Service responded with a failure code: " + httpConnection.getResponseCode() + httpConnection.getResponseMessage());
                }
            } else {
                throw new IOException("Unexpected URI type encountered");
            }
            reader = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder buffer = new StringBuilder();
            while ((str = reader.readLine()) != null) {
                buffer.append(str);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected static String buildAuthHeader(String username, String password) throws UnsupportedEncodingException {
        StringBuilder clearText = new StringBuilder(username);
        clearText.append(':');
        if (password != null) {
            clearText.append(password);
        }
        String headerResult = "Basic " + Base64.encodeBase64String((byte[])clearText.toString().getBytes("UTF-8"));
        return headerResult;
    }
}

