/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import java.awt.Point;

class Curve {
    int anchor1x;
    int anchor1y;
    int controlx;
    int controly;
    int anchor2x;
    int anchor2y;
    boolean isLine = false;

    Curve() {
    }

    Curve(Curve c2) {
        this.anchor1x = c2.anchor1x;
        this.anchor1y = c2.anchor1y;
        this.anchor2x = c2.anchor2x;
        this.anchor2y = c2.anchor2y;
        this.controlx = c2.controlx;
        this.controly = c2.controly;
        this.isLine = c2.isLine;
    }

    final void set(Point pt1, Point pt2) {
        this.anchor1x = pt1.x;
        this.anchor1y = pt1.y;
        this.anchor2x = pt2.x;
        this.anchor2y = pt2.y;
        this.controlx = (this.anchor1x + this.anchor2x) / 2;
        this.controly = (this.anchor1y + this.anchor2y) / 2;
        this.isLine = true;
    }

    final void set(Point pt1, Point control, Point pt2) {
        this.anchor1x = pt1.x;
        this.anchor1y = pt1.y;
        this.anchor2x = pt2.x;
        this.anchor2y = pt2.y;
        this.controlx = control.x;
        this.controly = control.y;
        this.isLine = false;
    }

    final Curve divide(int u) {
        Curve e2 = new Curve();
        e2.anchor2x = this.anchor2x;
        e2.anchor2y = this.anchor2y;
        e2.controlx = Matrix.mul(u, this.anchor2x - this.controlx) + this.controlx;
        e2.controly = Matrix.mul(u, this.anchor2y - this.controly) + this.controly;
        this.controlx = Matrix.mul(u, this.controlx - this.anchor1x) + this.anchor1x;
        this.controly = Matrix.mul(u, this.controly - this.anchor1y) + this.anchor1y;
        this.anchor2x = e2.anchor1x = Matrix.mul(u, e2.controlx - this.controlx) + this.controlx;
        this.anchor2y = e2.anchor1y = Matrix.mul(u, e2.controly - this.controly) + this.controly;
        e2.isLine = this.isLine;
        return e2;
    }

    final int flatness() {
        return Matrix.fastLength(this.controlx - (this.anchor1x + this.anchor2x) / 2, this.controly - (this.anchor1y + this.anchor2y) / 2);
    }

    final int XRaySect(Point pt, int depth) {
        Rect bounds = new Rect(this.anchor1x, this.anchor1y, this.anchor2x, this.anchor2y);
        if (this.controlx < bounds.xmin) {
            bounds.xmin = this.controlx;
        } else if (this.controlx > bounds.xmax) {
            bounds.xmax = this.controlx;
        }
        if (this.controly < bounds.ymin) {
            bounds.ymin = this.controly;
        } else if (this.controly > bounds.ymax) {
            bounds.ymax = this.controly;
        }
        if (bounds.xmax < pt.x || bounds.ymin > pt.y || bounds.ymax <= pt.y) {
            return 0;
        }
        if (bounds.pointIn(pt) && depth < 12 && Matrix.fastLength(bounds.xmax - bounds.xmin, bounds.ymax - bounds.ymin) > 4) {
            Curve a2 = new Curve(this);
            Curve b2 = a2.divide(32768);
            return a2.XRaySect(pt, ++depth) + b2.XRaySect(pt, depth);
        }
        int ymin = this.anchor1y;
        int ymax = this.anchor2y;
        if (ymin == ymax) {
            return 0;
        }
        if (ymin > ymax) {
            int tmp = ymin;
            ymin = ymax;
            ymax = tmp;
        }
        if (pt.y >= ymin && pt.y < ymax) {
            return 1;
        }
        return 0;
    }
}

