/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders.pod;

import io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.apache.commons.lang3.StringUtils;

public abstract class Volume {
    private final String name;

    protected Volume(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name mus not be null nor empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final io.fabric8.kubernetes.api.model.Volume build() {
        VolumeBuilder builder = (VolumeBuilder)new VolumeBuilder().withName(this.name);
        this.addVolumeParameters(builder);
        return builder.build();
    }

    protected abstract void addVolumeParameters(VolumeBuilder var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Volume)) {
            return false;
        }
        Volume volume = (Volume)o;
        return this.name.equals(volume.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

