/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders.buildconfig;

import cz.xtf.builder.builders.BuildConfigBuilder;
import cz.xtf.builder.builders.buildconfig.BuildStrategy;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.SourceBuildStrategyBuilder;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SourceBuildStrategy
extends BuildStrategy {
    private final Map<String, String> env = new HashMap<String, String>();
    private String imageStreamNamespace;
    private String imageStreamName;
    private String imageStreamTag;
    private String dockerImageUrl;
    private String scriptsLocation;
    private boolean incremental = false;
    private boolean forcePull = false;

    public SourceBuildStrategy(BuildConfigBuilder parent) {
        super(parent, "Source");
    }

    public SourceBuildStrategy fromImageStream(String namespace, String imageRepoName, String tag) {
        this.imageStreamNamespace = namespace;
        this.imageStreamName = imageRepoName;
        this.imageStreamTag = tag;
        return this;
    }

    public SourceBuildStrategy fromDockerImage(String imageUrl) {
        this.dockerImageUrl = imageUrl;
        return this;
    }

    public SourceBuildStrategy addEnvVariable(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public SourceBuildStrategy scriptsLocation(String scriptsLocation) {
        this.scriptsLocation = scriptsLocation;
        return this;
    }

    public SourceBuildStrategy incremental() {
        this.incremental = true;
        return this;
    }

    public SourceBuildStrategy forcePull() {
        this.forcePull = true;
        return this;
    }

    public SourceBuildStrategy forcePull(boolean forcePull) {
        this.forcePull = forcePull;
        return this;
    }

    public SourceBuildStrategy clean() {
        this.incremental = false;
        return this;
    }

    @Override
    protected void buildStrategy(BuildStrategyBuilder builder) {
        SourceBuildStrategyBuilder strategyBuilder = new SourceBuildStrategyBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.imageStreamName)) {
            if (StringUtils.isNotBlank((CharSequence)this.imageStreamTag)) {
                ((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)strategyBuilder.withNewFrom().withKind("ImageStreamTag")).withName(this.imageStreamName + ":" + this.imageStreamTag)).endFrom();
            } else {
                ((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)strategyBuilder.withNewFrom().withKind("ImageStream")).withName(this.imageStreamName)).endFrom();
            }
            if (StringUtils.isNotBlank((CharSequence)this.imageStreamNamespace)) {
                strategyBuilder.getFrom().setNamespace(this.imageStreamNamespace);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.dockerImageUrl)) {
            ((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)strategyBuilder.withNewFrom().withKind("DockerImage")).withName(this.dockerImageUrl)).endFrom();
        }
        strategyBuilder.withForcePull(Boolean.valueOf(this.forcePull));
        if (this.scriptsLocation != null) {
            strategyBuilder.withScripts(this.scriptsLocation);
        }
        strategyBuilder.withIncremental(Boolean.valueOf(this.incremental));
        strategyBuilder.withEnv(this.env.entrySet().stream().map(entry -> new EnvVar((String)entry.getKey(), (String)entry.getValue(), null)).collect(Collectors.toList()));
        builder.withSourceStrategy(strategyBuilder.build());
    }
}

