/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.ApplicationBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBuilder<T, R extends AbstractBuilder> {
    private final String name;
    private final ApplicationBuilder applicationBuilder;
    private final Map<String, String> labels = new HashMap<String, String>();
    private final Map<String, String> annotations = new HashMap<String, String>();

    protected AbstractBuilder(ApplicationBuilder applicationBuilder, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name can't be blank.");
        }
        this.applicationBuilder = applicationBuilder;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationBuilder app() {
        if (this.applicationBuilder == null) {
            throw new IllegalStateException("ApplicationBuilder was not set in constructor");
        }
        return this.applicationBuilder;
    }

    public R addLabel(String key, String value) {
        this.labels.put(key, value);
        return this.getThis();
    }

    public R addLabels(Map<String, String> labels) {
        labels.forEach((key, value) -> this.labels.put((String)key, (String)value));
        return this.getThis();
    }

    public R addAnnotation(String key, String value) {
        this.annotations.put(key, value);
        return this.getThis();
    }

    protected ObjectMetaBuilder metadataBuilder() {
        return (ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(this.name)).withAnnotations(this.annotations)).withLabels(this.labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractBuilder that = (AbstractBuilder)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public abstract T build();

    protected abstract R getThis();
}

