/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.builder.builders.DeploymentConfigBuilder;

public class StoragePartition {
    private final String mountPoint;
    private final int claimNumber;

    public StoragePartition(int claimNumber, String mountPoint) {
        this.mountPoint = mountPoint;
        this.claimNumber = claimNumber;
    }

    public void configureApplicationDeployment(ApplicationBuilder appBuilder, DeploymentConfigBuilder dcBuilder) {
        String volumeName = dcBuilder.app().getName() + "-" + this.claimNumber;
        appBuilder.pvc(volumeName).accessRWX().storageSize("512m");
        dcBuilder.podTemplate().addPersistenVolumeClaim(volumeName, volumeName);
        dcBuilder.podTemplate().container().addVolumeMount(volumeName, this.mountPoint, false);
    }
}

